-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore, pairs, type, vector
    = math, minetest, nodecore, pairs, type, vector
local math_random
    = math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

------------------------------------------------------------------------
-- NODE DEFINITIONS

local diggroups = {
	cracky = true,
	crumbly = true,
	choppy = true,
	snappy = true,
	thumpy = true,
	scratchy = true
}

local function register_mossy(subname, fromname)
	local olddef = minetest.registered_nodes[fromname]
	if not olddef then return end
	local tiles = {}
	for k, v in pairs(olddef.tiles) do
		if type(v) == "string" then
			v = v .. "^" .. modname .. "_mossy.png"
		end
		tiles[k] = v
	end
	local groups = {snappy = 1, mossy = 1}
	for k, v in pairs(olddef.groups) do
		if not diggroups[k] then groups[k] = v end
	end
	minetest.register_node(modname .. ":mossy_" .. subname, {
			nc_nature_mossy_of = fromname,
			description = "Mossy " .. olddef.description,
			tiles = tiles,
			drop_in_place = fromname,
			groups = groups,
			sounds = nodecore.sounds("nc_terrain_crunchy")
		})
end
register_mossy("cobble", "nc_terrain:cobble")
register_mossy("stone", "nc_terrain:stone")
register_mossy("thatch", modname .. ":thatch")
register_mossy("trunk", "nc_tree:tree")
register_mossy("dirt", "nc_terrain:dirt")
register_mossy("bricks", "nc_stonework:bricks")
register_mossy("bricks_bonded", "nc_stonework:bricks_bonded")
for i = 1, 7 do
	register_mossy("hstone" .. i, "nc_terrain:hard_stone_" .. i)
end

------------------------------------------------------------------------
-- SPREADING ABM

local breathable_drawtypes = {
	airlike = true,
	allfaces = true,
	allfaces_optional = true,
	torchlike = true,
	signlike = true,
	plantlike = true,
	firelike = true,
	raillike = true,
	nodebox = true,
	mesh = true,
	plantlike_rooted = true
}

local mossify = {}
local unmossify = {}
local breathable_nodes = {}
minetest.after(0, function()
		for k, v in pairs(minetest.registered_nodes) do
			if v.nc_nature_mossy_of then
				mossify[v.nc_nature_mossy_of] = k
				unmossify[k] = v.nc_nature_mossy_of
			end
			if breathable_drawtypes[v.drawtype] then
				breathable_nodes[k] = true
			end
		end
	end)

local alldirs = nodecore.dirs()
local function canbreathe(pos)
	local default = false
	for i = 1, #alldirs do
		local p = vector.add(pos, alldirs[i])
		local n = minetest.get_node(p)
		if breathable_nodes[n.name] then
			return true
		elseif n.name == "ignore" then
			default = nil
		end
	end
	return default
end

minetest.register_abm({
		label = "moss spreading",
		nodenames = {"group:mossy"},
		interval = 90,
		chance = 10,
		action = function(pos, node)
			local ok = canbreathe(pos)
			if ok == nil then return end
			if ok == false then
				local unmoss = unmossify[node.name]
				if not unmoss then return end
				return nodecore.set_node(pos, {name = unmoss})
			end
			local topos = {
				x = pos.x + math_random(-1, 1),
				y = pos.y + math_random(-1, 1),
				z = pos.z + math_random(-1, 1),
			}
			local tonode = minetest.get_node(topos)
			local mossto = mossify[tonode.name]
			if not (mossto and canbreathe(topos)) then return end
			return nodecore.set_loud(topos, {name = mossto})
		end
	})
