-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore
    = minetest, nodecore
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local mapperlin
minetest.after(0, function() mapperlin = minetest.get_perlin(8658, 1, 0, 1) end)

local materials = {
	shallow = {
		bulk = {
			plain = "nc_concrete:adobe",
			mossy = modname .. ":mossy_adobe"
		},
		brick = {
			plain = "nc_stonework:bricks_adobe",
			mossy = modname .. ":mossy_adobe_bricks"
		},
		bonded = {
			plain = "nc_stonework:bricks_adobe_bonded",
			mossy = modname .. ":mossy_adobe_bricks_bonded"
		}
	},
	deep = {
		bulk = {
			plain = "nc_terrain:cobble",
			mossy = modname .. ":mossy_cobble"
		},
		brick = {
			plain = "nc_stonework:bricks_stone",
			mossy = modname .. ":mossy_bricks"
		},
		bonded = {
			plain = "nc_stonework:bricks_stone_bonded",
			mossy = modname .. ":mossy_bricks_bonded"
		}
	}
}

nodecore.register_dungeongen({
		label = "nature dungeons",
		func = function(pos)
			if pos.y < -10 then return end
			local rng = nodecore.seeded_rng(mapperlin:get_3d(pos))
			local option = pos.y < 0 and rng(-10, 0) > pos.y
			and materials.deep or materials.shallow
			if rng(1, 4) ~= 1 then
				option = option.bulk
			else
				local below = {x = pos.x, y = pos.y - 1, z = pos.z}
				local bnode = minetest.get_node(below)
				local bdef = minetest.registered_nodes[bnode.name] or {}
				option = rng(1, 10) <= (bdef.walkable and 9 or 2)
				and option.brick or option.bonded
			end
			minetest.set_node(pos, {name = rng(1, 100) == 1
					and option.mossy or option.plain})
		end
	})
