-- LUALOCALS < ---------------------------------------------------------
local math, tonumber
    = math, tonumber
local math_floor
    = math.floor
-- LUALOCALS > ---------------------------------------------------------

-- luacheck: push
-- luacheck: globals config readtext readbinary

readtext = readtext or function() end
readbinary = readbinary or function() end

local stamp = tonumber("$Format:%at$")
if not stamp then return end
stamp = math_floor((stamp - 1540612800) / 60)
stamp = ("00000000" .. stamp):sub(-8)

return {
	user = "Warr1024",
	pkg = "nc_regression",
	min = "5.0",
	version = stamp .. "-$Format:%h$",
	path = ".",
	type = "texture pack",
	title = "Regression for NodeCore",
	short_desc = "Very first textures from NodeCore development.",
	tags = "16px",
	license = "mit",
	media_license = "mit",
	repo = "https://gitlab.com/sztest/nc_regression",
	issueTracker = "https://discord.gg/NNYeF6f",
	screenshots = {readbinary('.cdbscreen.jpg')}
}

-- luacheck: pop