-- LUALOCALS < ---------------------------------------------------------
local ItemStack, math, minetest, nodecore, vector
    = ItemStack, math, minetest, nodecore, vector
local math_random
    = math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local api = _G[modname]
local modstore = api.store

local storekey = "falling"
local s = modstore:get_string(storekey)
local cache = s and s ~= "" and minetest.deserialize(s) or {}

local function getfallingthings(ipos)
	local poskey = minetest.pos_to_string(ipos)
	local found = cache[poskey] or {item = {}, node = {}}
	return found, function()
		cache[poskey] = found
		return modstore:set_string(storekey, minetest.serialize(cache))
	end
end

local function fallingfor(self)
	local pos = self.object:get_pos()
	if not (pos and api.in_sky_realm(pos)) then return end
	local vel = self.object:get_velocity()
	if (not vel) or vel.y > -30 then return end

	local oy = pos.y
	while true do
		local node = minetest.get_node(pos)
		if node.name == "ignore" then break end
		if node.name ~= "air" then return end
		pos.y = pos.y - 1
	end
	pos.y = oy

	return api.island_near(pos) or api.island_near(pos, {x = 0, y = 1, z = 0})
end

local function poof(self, def)
	if not def then return self.object:remove() end
	local pos = self.object:get_pos()
	nodecore.digparticles(def, {
			time = 0.05,
			amount = 50,
			minpos = pos,
			maxpos = pos,
			minvel = {x = -5, y = -5, z = -5},
			maxvel = {x = 5, y = 5, z = 5},
			minexptime = 0.5,
			maxexptime = 1,
			minsize = 1,
			maxsize = 8
		})
	return self.object:remove()
end

nodecore.register_item_entity_step(function(self)
		local ipos = fallingfor(self)
		if not ipos then return end

		local pt, save = getfallingthings(ipos)
		pt = pt.item
		local stack = ItemStack(self.itemstring)
		local iname = stack:get_name()
		for i = 1, #pt do
			local pts = ItemStack(pt[i])
			stack = pts:add_item(stack)
			pt[i] = pts:to_string()
			if stack:is_empty() then break end
		end
		if not stack:is_empty() then
			pt[#pt + 1] = stack:to_string()
		end
		save()

		local def = minetest.registered_items[iname]
		return poof(self, def)
	end)

nodecore.register_falling_node_step(function(self)
		local ipos = fallingfor(self)
		if not ipos then return end

		local pt, save = getfallingthings(ipos)
		pt = pt.node
		pt[#pt + 1] = {
			n = self.node,
			m = self.meta
		}
		save()

		local def = minetest.registered_items[self.node.name]
		return poof(self, def)
	end)

local function findspot_start(pos)
	for rel in nodecore.settlescan() do

		local p = vector.add(pos, rel)
		if nodecore.buildable_to(p) then return p end
	end
end
local function findspot(pos)
	pos = findspot_start(pos)
	if not pos then return end
	local tpos = vector.add(pos, {
			x = math_random() * 10 - 5,
			y = math_random() * 10 + 5,
			z = math_random() * 10 - 5,
		})
	for hit in minetest.raycast(pos, tpos, false, false) do
		if hit.above and not vector.equals(pos, hit.above)
		and hit.under and not vector.equals(pos, hit.under)
		and nodecore.buildable_to(hit.above) then return hit.above end
	end
	return tpos
end
function api.return_falling(pos, ipos)
	local data, save = getfallingthings(ipos)

	local pt = data.item
	for i = #pt, 1, -1 do
		local p = findspot(pos)
		if p then
			nodecore.item_eject(p, pt[i], 1)
			pt[i] = nil
		else
			break
		end
	end

	pt = data.node
	for i = #pt, 1, -1 do
		local p = findspot(pos)
		if p then
			local obj = minetest.add_entity(p, "__builtin:falling_node")
			if obj then
				obj:get_luaentity():set_node(pt[i].n, pt[i].m)
				pt[i] = nil
			else
				break
			end
		else
			break
		end
	end

	save()
end
