-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore, pairs, string, table, vector
    = minetest, nodecore, pairs, string, table, vector
local string_format, string_sub, table_concat, table_sort
    = string.format, string.sub, table.concat, table.sort
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local api = _G[modname]

local emerge_interval = 5
local emerge_radius = vector.new(15, 15, 15)

local emerged_actions = {}
local action_prefix = "EMERGE_"
for k, v in pairs(minetest) do
	if string_sub(k, 1, #action_prefix) == action_prefix then
		emerged_actions[v] = string_sub(k, #action_prefix + 1):lower()
	end
end

local emerged = {}
function api.emerge_around(pos, reason)
	local key = minetest.hash_node_position(vector.round(pos))
	local done = emerged[key]
	if done and done > nodecore.gametime - emerge_interval then return end
	local loaded = {}
	local total = 0
	minetest.emerge_area(
		vector.subtract(pos, emerge_radius),
		vector.add(pos, emerge_radius),
		function(_, action, more)
			action = emerged_actions[action] or "unknown"
			if action == "from_memory" then return end
			loaded[action] = (loaded[action] or 0) + 1
			total = total + 1
			if more > 0 then return end
			local list = {}
			for k, v in pairs(loaded) do list[#list + 1] = k .. "=" .. v end
			table_sort(list)
			list[#list + 1] = "total=" .. total
			nodecore.log("info", string_format("skyrealm %s emerged %s",
					reason, table_concat(list, ", ")))
		end)
	emerged[key] = nodecore.gametime
end
