-- LUALOCALS < ---------------------------------------------------------
local ItemStack, math, minetest, nodecore, pairs, vector
    = ItemStack, math, minetest, nodecore, pairs, vector
local math_random
    = math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local api = _G[modname]

local cache = {}
local function getpthings(player, subkey)
	local metakey = modname .. "_fall_" .. subkey
	local cachekey = subkey .. ":" .. player:get_player_name()
	local found = cache[cachekey]
	if not found then
		local s = player:get_meta():get_string(metakey)
		found = s and s ~= "" and minetest.deserialize(s) or {}
		cache[cachekey] = found
	end
	return found, function()
		player:get_meta():set_string(metakey, minetest.serialize(found))
	end
end

local function fallingfor(self)
	local pos = self.object:get_pos()
	if not (pos and api.in_sky_realm(pos)) then return end
	local vel = self.object:get_velocity()
	if vel.y > -30 then return end

	local oy = pos.y
	while true do
		local node = minetest.get_node(pos)
		if node.name == "ignore" then break end
		if node.name ~= "air" then return end
		pos.y = pos.y - 1
	end
	pos.y = oy

	local pfound
	local pdist = 128
	for _, player in pairs(minetest.get_connected_players()) do
		local pp = player:get_pos()
		if pp and pp.y > pos.y then
			local dist = vector.distance(pos, pp)
			if dist < pdist then
				pdist = dist
				pfound = player
			end
		end
	end
	return pfound
end

local function poof(self, def)
	if not def then return self.object:remove() end
	local pos = self.object:get_pos()
	nodecore.digparticles(def, {
			time = 0.05,
			amount = 50,
			minpos = pos,
			maxpos = pos,
			minvel = {x = -5, y = -5, z = -5},
			maxvel = {x = 5, y = 5, z = 5},
			minexptime = 0.5,
			maxexptime = 1,
			minsize = 1,
			maxsize = 8
		})
	return self.object:remove()
end

nodecore.register_item_entity_step(function(self)
		local player = fallingfor(self)
		if not player then return end

		local pt, save = getpthings(player, "item")
		local stack = ItemStack(self.itemstring)
		local iname = stack:get_name()
		for i = 1, #pt do
			local pts = ItemStack(pt[i])
			stack = pts:add_item(stack)
			pt[i] = pts:to_string()
			if stack:is_empty() then break end
		end
		if not stack:is_empty() then
			pt[#pt + 1] = stack:to_string()
		end
		save()

		local def = minetest.registered_items[iname]
		return poof(self, def)
	end)

nodecore.register_falling_node_step(function(self)
		local player = fallingfor(self)
		if not player then return end

		local pt, save = getpthings(player, "node")
		pt[#pt + 1] = {
			n = self.node,
			m = self.meta
		}
		save()

		local def = minetest.registered_items[self.node.name]
		return poof(self, def)
	end)

local oldreturn = api.player_return
function api.player_return(player, ...)
	local function helper(...)
		local pos = player:get_pos()
		local pt, save = getpthings(player, "item")
		for i = #pt, 1, -1 do
			nodecore.item_eject(pos, pt[i], 5)
			pt[i] = nil
		end
		save()
		pt, save = getpthings(player, "node")
		for i = #pt, 1, -1 do
			local obj = minetest.add_entity(vector.add(pos, {
						x = math_random() * 10 - 5,
						y = math_random() * 10 + 5,
						z = math_random() * 10 - 5,
					}), "__builtin:falling_node")
			if obj then
				obj:get_luaentity():set_node(pt[i].n, pt[i].m)
			end
			pt[i] = nil
		end
		save()
		return ...
	end
	return helper(oldreturn(player, ...))
end
