-- LUALOCALS < ---------------------------------------------------------
local math, minetest, nodecore, pairs, setmetatable, string
    = math, minetest, nodecore, pairs, setmetatable, string
local math_random, string_format
    = math.random, string.format
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local api = _G[modname]

do
	local key = "portals"
	local modstore = minetest.get_mod_storage()
	local s = modstore:get_string(key) or ""
	local data = s and s ~= "" and minetest.deserialize(s) or {}
	local dirty
	local access = {}
	api.portaldata = access
	local function getkey(pos) return minetest.pos_to_string(api.island_grid_round(pos)) end
	local ameta = {
		__index = function(_, k) return data[getkey(k)] end,
		__newindex = function(_, k, v) data[getkey(k)] = vector.round(v) dirty = true end
	}
	setmetatable(access, ameta)
	nodecore.interval(1, function()
			if not dirty then return end
			modstore:set_string(key, minetest.serialize(data))
			dirty = nil
		end)
end

local portalname = modname .. ":portal"

local function mkisland(pos)
	pos = pos and api.in_sky_realm(pos) and pos
	local ipos = api.island_near(pos or {
			x = (math_random() * 2 - 1) * api.islands_xzextent,
			y = api.islands_ymin + (api.islands_ymax - api.islands_ymin) * math_random(),
			z = (math_random() * 2 - 1) * api.islands_xzextent
		})
	if ipos then return ipos end
	return mkisland()
end

local function getassign(meta, pos, noset)
	local found = meta:get_string(modname)
	if found ~= "" then return minetest.string_to_pos(found) end
	if noset then return end
	local ipos = mkisland(pos)
	meta:set_string(modname, minetest.pos_to_string(ipos))
	return ipos
end

local function portaltick(pos, att, stack)
	local assign = getassign(stack and stack:get_meta()
		or minetest.get_meta(pos), nil, not stack)
	if assign then api.portaldata[assign] = pos end
	if att then
		pos = {x = 0, y = 0, z = 0}
		if att:is_player() then
			pos.y = pos.y + att:get_properties().eye_height
		end
	end
	minetest.add_particlespawner({
			time = 1,
			amount = 50,
			minpos = pos,
			maxpos = pos,
			minacc = {x = -0.2, y = -0.2, z = -0.2},
			maxacc = {x = 0.2, y = 0.2, z = 0.2},
			minexptime = 1,
			maxexptime = 5,
			minsize = 0.2,
			maxsize = 1,
			texture = "[combine:1x1^[noalpha",
			collisiondetection = true,
			collision_removal = true,
			attached = att
		})
	return stack
end
local function portaltickstart(pos)
	nodecore.dnt_reset(pos, modname .. ":porticles")
	return portaltick(pos)
end

minetest.register_node(portalname, {
		description = "SkyRealm Portal",
		drawtype = "nodebox",
		node_box = nodecore.fixedbox(
			{-5/16, -4/16, -3/16, 5/16, -2/16, 3/16},
			{-3/16, -4/16, -5/16, 3/16, -2/16, 5/16},
			{-3/16, -6/16, -3/16, 3/16, -2/16, 3/16},
			{-1/16, -7/16, -1/16, 1/16, 2/16, 1/16},
			{-5/16, 2/16, -3/16, 5/16, 6/16, 3/16},
			{-3/16, 2/16, -5/16, 3/16, 6/16, 5/16},
			{-3/16, 0/16, -3/16, 3/16, 8/16, 3/16}
		),
		tiles = {"[combine:1x1^[noalpha"},
		collision_box = nodecore.fixedbox(),
		selection_box = nodecore.fixedbox(-5/16, -7/16, -5/16, 5/16, 8/16, 5/16),
		stack_max = 1,
		groups = {cracky = 6},
		paramtype = "light",
		light_source = 4,
		sounds = nodecore.sounds("nc_terrain_stony"),
		preserve_metadata = function(_, _, oldmeta, drops)
			drops[1]:get_meta():set_string(modname, oldmeta[modname])
		end,
		after_place_node = function(pos, _, itemstack)
			minetest.get_meta(pos):set_string(modname,
				itemstack:get_meta():get_string(modname))
		end,
		on_stack_touchtip = function(stack, name)
			local ipos = getassign(stack:get_meta())
			return name .. "\n" .. string_format("%x",
				minetest.hash_node_position(ipos)):upper()
		end,
		on_node_touchtip = function(pos, _, name)
			local ipos = getassign(minetest.get_meta(pos), pos)
			return name .. "\n" .. string_format("%x",
				minetest.hash_node_position(ipos)):upper()
		end,
		on_construct = portaltickstart
	})

nodecore.register_dnt({
		name = modname .. ":porticles",
		time = 1,
		loop = true,
		nodenames = {portalname},
		action = function(pos) return portaltick(pos) end
	})
nodecore.register_lbm({
		name = modname .. ":porticles",
		nodenames = {portalname},
		run_at_every_load = true,
		action = portaltickstart
	})
nodecore.register_aism({
		label = "SkyRealm Portal Stack FX",
		chance = 1,
		interval = 1,
		itemnames = {portalname},
		action = function(stack, data)
			return portaltick(data.pos, data.player or data.obj, stack)
		end
	})

nodecore.register_craft({
		label = "skyrealm teleport",
		action = "pummel",
		duration = 2,
		touchgroups = {flame = 5},
		check = function(pos) return not api.in_sky_realm(pos) end,
		nodes = {
			{
				match = portalname
			}
		},
		after = function(pos, data)
			if data.crafter then
				local ipos = getassign(minetest.get_meta(pos), pos)
				for _, p in pairs(nodecore.find_nodes_around(pos, "group:flame")) do
					nodecore.sound_play("nc_fire_snuff", {gain = 1, pos = p})
					minetest.remove_node(p)
				end
				for _, p in pairs(nodecore.find_nodes_around(pos, "group:ember", 2)) do
					nodecore.set_loud(p, {name = "nc_fire:ash"})
				end
				api.player_enter(data.crafter, ipos)
			end
		end
	})

local function airscan(pos)
	local nn = minetest.get_node(pos).name
	if nn == "ignore" then return true end
	if nn ~= "air" then return end
	pos.y = pos.y - 1
	return airscan(pos)
end
local function scanaround(pos)
	return airscan({x = pos.x, y = pos.y, z = pos.z})
	and airscan({x = pos.x + 1, y = pos.y, z = pos.z})
	and airscan({x = pos.x - 1, y = pos.y, z = pos.z})
	and airscan({x = pos.x, y = pos.y, z = pos.z + 1})
	and airscan({x = pos.x, y = pos.y, z = pos.z - 1})
	and airscan({x = pos.x + 1, y = pos.y, z = pos.z + 1})
	and airscan({x = pos.x + 1, y = pos.y, z = pos.z - 1})
	and airscan({x = pos.x - 1, y = pos.y, z = pos.z + 1})
	and airscan({x = pos.x - 1, y = pos.y, z = pos.z - 1})
end
local function checkplayer(player, dtime)
	local pos = player:get_pos()
	if not api.in_sky_realm(pos) then return end
	local data, save = api.playerdata(player)
	if player:get_player_velocity().y > 0 or not scanaround(pos) then
		if data.falling then
			data.falling = nil
			return save()
		end
		return
	end
	data.falling = (data.falling or 0) + dtime
	if data.falling >= 5 then
		data.falling = nil
		if nodecore.player_stat_add then
			nodecore.player_stat_add(1, player, "craft", "skyrealm return")
		end
		return api.player_return(player)
	end
	return save()
end
minetest.register_globalstep(function(dtime)
		for _, player in pairs(minetest.get_connected_players()) do
			checkplayer(player, dtime)
		end
	end)

nodecore.register_craft({
		label = "build skyrealm portal",
		action = "pummel",
		toolgroups = {thumpy = 6},
		norotate = true,
		nodes = {
			{
				match = "nc_lode:block_hot",
				replace = portalname
			},
			{
				y = -1,
				match = "nc_tree:root",
				replace = "nc_fire:ember5"
			},
			{
				y = 1,
				match = {groups = {lux_fluid = true}},
				replace = "nc_fire:ember1"
			},
			{
				x = 1,
				match = {groups = {lux_fluid = true}},
				replace = "nc_fire:ember1"
			},
			{
				x = -1,
				match = {groups = {lux_fluid = true}},
				replace = "nc_fire:ember1"
			},
			{
				z = 1,
				match = {groups = {lux_fluid = true}},
				replace = "nc_fire:ember1"
			},
			{
				z = -1,
				match = {groups = {lux_fluid = true}},
				replace = "nc_fire:ember1"
			}
		},
		after = function(pos) return getassign(minetest.get_meta(pos), pos) end
	})

local addhint = nodecore.register_hint or nodecore.addhint
addhint("create a skyrealm portal",
	"build skyrealm portal",
	{
		"toolcap:thumpy:6",
		"forge lode block",
		"nc_tree:root",
		"group:lux_cobble_max"
	})
addhint("enter the skyrealm",
	"skyrealm teleport",
	"build skyrealm portal"
)

local skyhint = api.addskyhint
skyhint("fall back to the surface world",
	"skyrealm return",
	"skyrealm teleport"
)
