-- LUALOCALS < ---------------------------------------------------------
local minetest, nodecore, pairs, vector
    = minetest, nodecore, pairs, vector
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()

local glyph = "nc_writing:glyph1"
local maxdist = tonumber(minetest.settings:get(modname .. "_maxdist")) or 32
local minpower = tonumber(minetest.settings:get(modname .. "_minpower")) or 3

local function sparkly(pos)
	minetest.add_particlespawner({
			amount = 20,
			time = 0.25,
			minpos = {x = pos.x - 0.5, y = pos.y - 0.5, z = pos.z - 0.5},
			maxpos = {x = pos.x + 0.5, y = pos.y + 1.5, z = pos.z + 0.5},
			minvel = {x = -0.5, y = -0.5, z = -0.5},
			maxvel = {x = 0.5, y = 0.5, z = 0.5},
			texture = "nc_lux_base.png^[mask:nc_lux_dot_mask.png^[opacity:128",
			minexptime = 0.20,
			maxexptime = 0.25,
			glow = 4
		})
end

local function zipscan(pos, dir)
	for i = 1, maxdist - 1 do
		local p = {
			x = pos.x + dir.x * i,
			y = pos.y + dir.y * i,
			z = pos.z + dir.z * i
		}
		if nodecore.walkable(p) then return end
		if dir.y == 0 and nodecore.walkable({x = p.x, y = p.y + 1, z = p.z}) then return end
		local node = minetest.get_node(p)
		local face = nodecore.facedirs[node.param2]
		if node.name == glyph and vector.equals(face.k, dir) then
			if dir.y == 1 then dir = vector.add(dir, face.b) end
			return vector.add(p, dir)
		end
	end
end

local function zipcheck(player, pos, commit)
	local node = minetest.get_node(pos)

	local face = nodecore.facedirs[node.param2]
	local dir = face.k
	local hit = zipscan(pos, dir)
	if not hit then return end

	if nodecore.walkable(hit) or
	nodecore.walkable({x = hit.x, y = hit.y + 1, z = hit.z})
	then return end

	player:set_pos({x = hit.x, y = hit.y - 0.49, z = hit.z})
	sparkly(hit)
	commit(hit)

	return true
end

local cache = {}

local function playercheck(player)
	local vel = player:get_player_velocity()
	if vector.dot(vel, vel) > 0.1 then return end

	local pname = player:get_player_name()
	local found = cache[pname]
	if not found then
		local s = player:get_meta():get_string(modname) or ""
		found = s and s ~= "" and minetest.string_to_pos(s) or {}
		cache[pname] = found
	end
	if not found.x then return end

	local pos = vector.round(player:get_pos())
	if vector.distance(pos, found) > 2 then
		cache[pname] = {}
		player:get_meta():set_string(modname, "")
		return
	end

	for _, p in pairs(nodecore.find_nodes_around(pos, glyph, 1)) do
		if zipcheck(player, p,
			function(dest)
				cache[pname] = dest
				player:get_meta():set_string(modname, minetest.pos_to_string(dest))
			end
		) then return end
	end
end

minetest.register_globalstep(function()
		for _, player in pairs(minetest.get_connected_players()) do
			playercheck(player)
		end
	end)

local powernodes = {}
for i = minpower, 8 do powernodes["nc_lux:cobble" .. i] = true end

nodecore.register_limited_abm({
		label = "ZipRune Detection",
		interval = 1,
		chance = 1,
		limited_max = 100,
		limited_alert = 1000,
		nodenames = {glyph},
		neighbors = {"group:lux_cobble"},
		action = function(pos, node)
			local face = nodecore.facedirs[node.param2]

			local unode = minetest.get_node(vector.add(pos, face.b))
			if not powernodes[unode.name] then return end

			if not zipscan(pos, face.k) then return end

			minetest.add_particlespawner({
					amount = 20,
					time = 1,
					minpos = {x = pos.x - 0.5, y = pos.y - 7/16, z = pos.z - 0.5},
					maxpos = {x = pos.x + 0.5, y = pos.y - 7/16, z = pos.z + 0.5},
					minvel = {x = 0, y = 0, z = 0},
					maxvel = {x = 0, y = 0, z = 0},
					minacc = {x = 0, y = 1, z = 0},
					maxacc = {x = 0, y = 1, z = 0},
					texture = "nc_lux_base.png^[mask:nc_lux_dot_mask.png^[opacity:128",
					minexptime = 1,
					maxexptime = 2,
					glow = 4
				})

			for _, player in pairs(minetest.get_connected_players()) do
				if vector.equals(vector.round(player:get_pos()), pos) then
					cache[player:get_player_name()] = pos
					player:get_meta():set_string(modname,
						minetest.pos_to_string(pos))
				end
			end
		end
	})
