-- LUALOCALS < ---------------------------------------------------------
local core, math, pairs, piredo_api, piredo_map, piredo_player,
      piredo_schems
    = core, math, pairs, piredo_api, piredo_map, piredo_player,
      piredo_schems
local math_random
    = math.random
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local modstore = core.get_mod_storage()

local api = piredo_api.get_mod_api()

local data, save = arclib.util.structstore(modstore, modname)("received_items")

local metabyid

local giveitems_pending
local function giveitems()
	giveitems_pending = nil
	local state = api.manager.state

	-- Lookup of metadata by ID is required, build it only once
	if not metabyid then
		local slotdata = state and state.slot_data
		local items = slotdata and slotdata.items
		if items then
			metabyid = {}
			for _, meta in pairs(items) do
				metabyid[meta.id] = meta
			end
		end
	end
	if not metabyid then return end

	-- Must have received items array
	local recvd = state.items_received
	if not recvd then return end

	-- Get player inventory
	local player = piredo_player.mainplayer()
	if not player then return end
	local inv = player:get_inventory()

	-- Reconcile every received item, keep track of whether
	-- we need to retry anything.
	local deferred
	for i = 1, #recvd do
		if not data[i] then
			local meta = metabyid[recvd[i].item]
			if meta and meta.piredo_inventory then
				-- Give tangible items
				local left = inv:add_item("main", meta.piredo_inventory)
				if left:is_empty() then
					data[i] = true
					api.received("item")
				else
					deferred = true
				end
			elseif meta and meta.piredo_room_access then
				-- Give room access
				modstore:set_string("room:" .. meta.piredo_room_access, "1")
				local schem = piredo_schems[meta.piredo_room_access]
				api.received("room")
				data[i] = true
			else
				core.log("error", "invalid item received " .. dump(meta))
				data[i] = true
			end
		end
	end
	save()

	-- If anything needed to be deferred, make sure we have
	-- a retry pending, but don't let them pile up
	if deferred and not giveitems_pending then
		giveitems_pending = true
		core.after(1, giveitems)
	end
end

api.manager.on("update", giveitems)

core.register_on_joinplayer(giveitems)

-- Room access control
do
	local old = piredo_map.chooseroom
	local function reject(reason, ...)
		core.log("action", "[piranesipelago] Rejected room entry: " .. reason)
		local quads = piredo_map.find_schematics("quad_hall")
		return quads[math_random(1, #quads)], ...
	end
	function piredo_map.chooseroom(...)
		local function helper(picked, ...)
			-- Check if player has access flag for this room
			if modstore:get_string("room:" .. picked) ~= "" then
				return picked, ...
			end

			-- If no slot data available, can't check requirements
			local state = api.manager.state
			if not state.slot_data or not state.slot_data.items then
				return reject("no slot item data", ...)
			end

			-- Check if this room requires an access item
			for _, metadata in pairs(state.slot_data.items) do
				if metadata.piredo_room_access == picked then
					-- Room requires access item, but player doesn't have it
					return reject("need access item: " .. metadata.name, ...)
				end
			end

			-- Room doesn't require access, or player has access
			return picked, ...
		end
		return helper(old(...))
	end
end
