-- LUALOCALS < ---------------------------------------------------------
local core, next, pairs, piredo_api
    = core, next, pairs, piredo_api
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local myname = modname .. ":apitem"

local api = piredo_api.get_mod_api()

local hashpos = core.hash_node_position

local entidx = {}

core.register_entity(myname, {
		initial_properties = {
			visual = "sprite",
			textures = {"piranesi_archipelago_apitem.png"},
			pointable = false,
		},
		on_step = function(self)
			local pos = self.object:get_pos()
			if not pos then return end
			if core.get_node(pos).name ~= myname then
				return self.object:remove()
			end
		end
	})

core.register_node(myname, {
		drawtype = "airlike",
		paramtype = "light",
		sunlight_propagates = true,
		on_construct = function(pos)
			local hash = hashpos(pos)
			entidx[hash] = entidx[hash] or core.add_entity(pos, myname)
		end,
		on_punch = function(pos)
			api.sendcheck(core.get_meta(pos):get_float(modname))
			local hash = hashpos(pos)
			if entidx[hash] then
				entidx[hash]:remove()
				entidx[hash] = nil
			end
			core.remove_node(pos)
		end
	})

do
	local check = {}
	core.register_abm({
			interval = 1,
			chance = 1,
			nodenames = {myname},
			action = function(pos)
				check[hashpos(pos)] = pos
			end
		})
	core.register_globalstep(function()
			if not next(check) then return end
			local exist = {}
			for _, v in pairs(core.luaentities) do
				if v.name == myname then
					local pos = v.object:get_pos()
					if pos then
						exist[hashpos(pos)] = pos
					end
				end
			end
			for k, v in pairs(check) do
				if not exist[k] then
					core.add_entity(v, myname)
				end
			end
		end)
end
