# piranesi_archipelago - Piranesi Archipelago Client Mod

This mod acts as the client-side bridge between **[Piranesi Restoration Project](https://content.luanti.org/packages/Warr1024/piranesi_redo/)** and an **[Archipelago multiworld randomizer](https://archipelago.gg/)** server. It handles:

- **Item Reception** - Receives items from other players and adds them to inventory or grants room access
- **Location Checks** - Sends checks when solving puzzles, entering rooms, and collecting items  
- **HUD Display** - Shows received room access items in the corner of the screen
- **Chat Integration** - Bridges game chat with Archipelago server chat

The mod is also packaged with `piranesi.apworld`, the Archipelago server-side component (a zip file containing source code and data that define's the game's configuration and logic).

## Dependencies

This mod requires:
- **Piranesi Restoration Project** game (all its internal mods)
- `[arclib](https://content.luanti.org/packages/Warr1024/arclib/)` - Archipelago communication library (external dependency)

## Installation

1. Install the `piranesi_archipelago` mod to your Luanti mods folder.  Recommended method is installation via the Content browser.

2. Enable the mod when creating a new Piranesi world.

## Setup

Before playing, you need to join an Archipelago multiworld:

### Step 1: Prepare Your Player Files

1. **Copy the example YAML**: Edit `example-player.yaml` with your preferred player name and settings
2. **Send to host**: Give your YAML file to the person hosting the multiworld

### Step 2: Provide Game Package

Give the `piranesi.apworld` file (included with this mod) to the multiworld host. They need this to generate the randomized world.

### Step 3: Wait for Multiworld

The host will generate the multiworld and provide you with:
- Server address (e.g., `wss://archipelago.gg:54321`)
- Your slot name (matches your YAML file name)
- Room password (if required)

## Usage

### Step 1: Start WebSocket Proxy

Before connecting, you must run the WebSocket proxy:
1. The WebSocket proxy is included with the `arclib` dependency
2. Run the proxy (binary for your platform or run from source) from a terminal/command prompt
3. The proxy will listen on `http://localhost:9839`

### Step 2: Connect to Archipelago

In-game, use the `/ap` command to open the configuration form and enter:
- **Server URL** - The server address from your host
- **Slot Name** - Your player name from the YAML file  
- **Password** - Room password (if required)

Click "Connect" to join the multiworld.

### Step 3: Play!

As you explore Piranesi:

- Enter new rooms, solve puzzles, and collect items to send checks.
- Receive items and access to rooms from the multiworld.
- Complete the final puzzle and escape the mansion for goal completion.
- Don't forget about hidden content!

## Features

### Item Handling

The mod processes two types of received items:

1. **Inventory Items** - Added directly to your inventory (tools, materials, etc.)
2. **Room Access** - Grants access to specific rooms you couldn't enter before

Room access is displayed via a HUD.  Rooms that you don't have access to yet will be replaced by empty hallways; expect to travel through a lot of empty hallways early in the game before you've unlocked many rooms.

### Location Checks

Automatically sends location checks when you:

- **Solve major puzzles** - Complete key puzzles throughout the mansion
- **Enter new rooms** - First time entering specific important rooms
- **Collect items** - Pick up replaced items found in the world

### Chat Bridge

In-game chat is bridged to Archipelago.  See items other players are sending, use commands like !hint, and chat with other players who are using the chat.

## Known Issues & Balance Notes

### Forest Machine Puzzle

The Forest Machine puzzle requires many items (pewter key, pewter sword, pewter plate, obsidian pot, forge access, mold, axe) for a single check, which is somewhat unbalanced.  Ideally, we would break it up into several component puzzles, but the mechanics of the gear-molding process make this difficult.

### Potion Bottles

Potion brewing does not consume bottles like it does in vanilla.  This can feel weird, but it actually helps with progression, because archipelago works the most straight-forwardly when progression items are permanent and non-consumable.

### Crown Stacking

Crowns are stackable (they aren't in vanilla).  This is just a quirk of how item handling differs and it's not incorrect in either case.

### Final Exit Softlock

If you leave the mansion via the final exit before completing all checks inside (including the Treasure Room) then you will be unable to complete those checks in that world.  To access those again, you will need to start a new world, reconnect and re-receive your items, and complete the necessary puzzles and checks.

## AI Disclosure

This project was developed jointly by human developer(s) and AI coding agent(s). AI models used may include members of the following model families: Anthropic Claude 4.x, OpenAI GPT-5, and OpenCode Zen Big Pickle (based on GLM-4.x). Agent access to the project was managed by SST's OpenCode tool.