-- LUALOCALS < ---------------------------------------------------------
local core, math, next, pairs, piredo_api, vector
    = core, math, next, pairs, piredo_api, vector
local math_cos, math_pi, math_random, math_sin
    = math.cos, math.pi, math.random, math.sin
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local myname = modname .. ":apitem"

local api = piredo_api.get_mod_api()

local hashpos = core.hash_node_position

core.register_entity(myname, {
		initial_properties = {
			visual_size = {x = 0.5, y = 0.5, z = 0.5},
			static_save = false,
			visual = "sprite",
			pointable = false,
		},
		on_step = function(self)
			local pos = self.object:get_pos()
			if not pos then return end
			if core.get_node(pos).name ~= myname then
				return self.object:remove()
			end
		end
	})

local orbradius = 0.3
local searchradius = orbradius + 0.05

local colors = {
	"#ff8080",
	"#e0e080",
	"#80ff80",
	"#80e0e0",
	"#8080ff",
	"#e080e0"
}
local function createsprites(pos)
	local offset = math_pi * 2 * math_random()
	for i = 1, 6 do
		local theta = offset + i / 6 * math_pi * 2
		local p = vector.offset(pos,
			math_cos(theta) * orbradius,
			0,
			math_sin(theta) * orbradius)
		local obj = core.add_entity(p, myname)
		obj:set_properties({
				textures = {"piranesi_archipelago_apitem.png^[multiply:" .. colors[i]},
			})
	end
end

core.register_node(myname, {
		drawtype = "airlike",
		paramtype = "light",
		sunlight_propagates = true,
		on_construct = function(pos)
			if #core.get_objects_inside_radius(pos, searchradius) < 1 then
				createsprites(pos)
			end
		end,
		on_punch = function(pos)
			api.sendcheck(core.get_meta(pos):get_float(modname))
			for obj in core.objects_inside_radius(pos, searchradius) do
				obj:remove()
			end
			core.remove_node(pos)
		end
	})

-- Patrol for nodes missing entities, because the pure transactional
-- logic can sometimes "miss" nodes that need to have entities assigned
-- and we can end up with invisible nodes without their display sprites.
do
	local check = {}
	core.register_abm({
			interval = 1,
			chance = 1,
			nodenames = {myname},
			action = function(pos)
				check[hashpos(pos)] = pos
			end
		})
	core.register_globalstep(function()
			if not next(check) then return end
			local exist = {}
			for _, v in pairs(core.luaentities) do
				if v.name == myname then
					local pos = v.object:get_pos()
					if pos then
						pos = vector.round(pos)
						exist[hashpos(pos)] = pos
					end
				end
			end
			for k, v in pairs(check) do
				if not exist[k] then
					createsprites(v)
				end
			end
		end)
end
