-- LUALOCALS < ---------------------------------------------------------
local core, ipairs, piredo_api, piredo_player
    = core, ipairs, piredo_api, piredo_player
-- LUALOCALS > ---------------------------------------------------------

local api = piredo_api.get_mod_api()

-- Build index of already-checked locations
local function alreadychecked(state)
	local checked = {}
	for _, i in ipairs(state and state.checked_locations or {}) do
		checked[i] = true
	end
	return checked
end
api.alreadychecked = alreadychecked

-- Send a check
local function sendcheck(id, pos)
	local manager = api.manager
	local state = manager and manager.state
	if not state then return end
	local already = alreadychecked(state)
	if already[id] then return end
	local params = {pos = pos}
	if params.pos then params.object = piredo_player.mainplayer() end
	core.sound_play("piranesi_archipelago_send", params, true)
	return api.manager:check_location(id)
end
api.sendcheck = sendcheck

local function sendgoal()
	return core.sound_play("piranesi_archipelago_goal",
		{player = piredo_player.mainplayer()}, true)
end
api.sendgoal = sendgoal

local function received(recvtype)
	return core.sound_play("piranesi_archipelago_recv_" .. recvtype,
		{player = piredo_player.mainplayer()}, true)
end
api.received = received
