-- LUALOCALS < ---------------------------------------------------------
local core, piredo_api
    = core, piredo_api
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local modstore = core.get_mod_storage()

-- Get shared API table
local api = piredo_api.get_mod_api()

-- Create shared arclib manager instance
api.manager = arclib.manager({
		url_server = nil,
		login_slotname = nil,
		login_password = nil,
		login_gamename = "Piranesi Restoration Project",
		modstore = modstore,
	})

-- Persist config, and command to access it
arclib.ux.configure({
		modstore = modstore,
		manager = api.manager
	})
core.register_chatcommand("ap", {
		description = "Show Archipelago config form",
		func = function(name)
			arclib.ux.configure({
					modstore = modstore,
					player = name,
					manager = api.manager,
				})
		end
	})

-- Always disconnect on shutdown
core.register_on_shutdown(function()
		api.manager:close()
	end)

-- game <-> arc chat bridge
api.manager.on("printtext", core.chat_send_all)
core.register_on_chat_message(function(_, msg)
		api.manager:say(msg)
	end)

-- Load submodules
piredo_api.include("api")
piredo_api.include("roomhud")
piredo_api.include("node")
piredo_api.include("items")
piredo_api.include("locations")
