-- LUALOCALS < ---------------------------------------------------------
local core, ipairs, piredo_api
    = core, ipairs, piredo_api
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local myname = modname .. ":apitem"

local api = piredo_api.get_mod_api()

core.register_node(myname, {
		drawtype = "airlike",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		on_construct = arclib.itemvis.node_apply,
		after_destruct = arclib.itemvis.node_apply,
		on_punch = function(pos)
			api.sendcheck(core.get_meta(pos):get_float(modname))
			for _, v in ipairs(arclib.itemvis.inside_radius(pos, 0.5)) do
				v:explode()
			end
			core.remove_node(pos)
		end
	})

arclib.itemvis.node_register({myname})
