-- LUALOCALS < ---------------------------------------------------------
local core, ipairs, piredo_api, piredo_player
    = core, ipairs, piredo_api, piredo_player
-- LUALOCALS > ---------------------------------------------------------

local api = piredo_api.get_mod_api()

-- Build index of already-checked locations
local function alreadychecked(state)
	local checked = {}
	for _, i in ipairs(state and state.checked_locations or {}) do
		checked[i] = true
	end
	return checked
end
api.alreadychecked = alreadychecked

-- Visual/sound effects for things
local function sentitemfx(pos)
	local params = {pos = pos}
	if params.pos then params.object = piredo_player.mainplayer() end
	core.sound_play("piranesi_archipelago_send", params, true)
end
api.sentitemfx = sentitemfx
local function sentgoalfx()
	return core.sound_play("piranesi_archipelago_goal",
		{player = piredo_player.mainplayer()}, true)
end
api.sentgoalfx = sentgoalfx
local function receivedfx(recvtype)
	return core.sound_play("piranesi_archipelago_recv_" .. recvtype,
		{player = piredo_player.mainplayer()}, true)
end
api.receivedfx = receivedfx

-- Send a check
local function sendcheck(id, pos)
	local manager = api.manager
	local state = manager and manager.state
	if not state then return end
	local already = alreadychecked(state)
	if already[id] then return end
	api.manager:check_location(id)
	return sentitemfx(pos)
end
api.sendcheck = sendcheck
