-- LUALOCALS < ---------------------------------------------------------
local core, ipairs, pairs, piredo_api, piredo_player, piredo_schems,
      string
    = core, ipairs, pairs, piredo_api, piredo_player, piredo_schems,
      string
local string_format, string_rep
    = string.format, string.rep
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local modstore = core.get_mod_storage()

local api = piredo_api.get_mod_api()

local hudidx = {}

core.register_on_leaveplayer(function(player)
		hudidx[player:get_player_name()] = nil
	end)

function api.update_room_access_hud()
	local player = piredo_player.mainplayer()
	if not player then return end

	local huds = hudidx[player:get_player_name()]
	if not huds then
		huds = {}
		hudidx[player:get_player_name()] = huds
	end

	local state = api.manager.state

	local max = 0
	local lut = {}
	for _, meta in pairs(api.apdata.items or {}) do
		lut[meta.id] = meta
		if meta.piredo_room_access then max = max + 1 end
	end

	local lines = {}

	do
		local checked = api.alreadychecked(state)
		local done = 0
		local total = 0
		for _, metadata in pairs(api.apdata.locations) do
			if checked[metadata.id] then done = done + 1 end
			total = total + 1
		end
		lines[#lines + 1] = string_format("Checked %d / %d (%d%%)",
			done, total, done * 100 / total)
		lines[#lines + 1] = ""
	end
	max = max + 2

	for _, item in ipairs(state and state.items_received or {}) do
		local meta = lut[item.item]
		if meta and meta.piredo_room_access then
			local schem = piredo_schems[meta.piredo_room_access]
			lines[#lines + 1] = schem and schem.title or meta.name or item.item
		end
	end

	for i = 1, max do
		local text = lines[i]
		local text = text and (text .. string_rep("\n", i - 1))
		if text then
			local old = huds[i]
			if old and old.text ~= text then
				player:hud_change(old.id, "text", text)
				old.text = text
			elseif not old then
				huds[i] = {
					text = text,
					id = player:hud_add({
							type = "text",
							position = {x = 1, y = 1},
							text = text,
							number = 0xFFFFFF,
							alignment = {x = -1, y = -1},
							offset = {x = -4, y = -4},
							z_index = -300,
						})
				}
			end
		elseif huds[i] then
			player:hud_remove(huds[i].id)
			huds[i] = nil
		end
	end
end

api.manager.on("update", api.update_room_access_hud)

core.register_on_joinplayer(api.update_room_access_hud)
