-- LUALOCALS < ---------------------------------------------------------
local core, ipairs, piredo_api, string, table
    = core, ipairs, piredo_api, string, table
local string_upper, table_concat
    = string.upper, table.concat
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local myname = modname .. ":apitem"

local api = piredo_api.get_mod_api()

local flags_hint = {"priority", "avoid", "progression", "useful", "trap"}
local flags_nohint = {"progression"}

core.register_node(myname, {
		drawtype = "airlike",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		on_construct = arclib.itemvis.node_apply,
		after_destruct = arclib.itemvis.node_apply,
		on_punch = function(pos)
			api.sendcheck(core.get_meta(pos):get_float(modname))
			for _, v in ipairs(arclib.itemvis.inside_radius(pos, 0.5)) do
				v:explode()
			end
			core.remove_node(pos)
		end,
		_arclib_get_location_flags = function(pos)
			local id = core.get_meta(pos):get_float(modname)
			local info = api.manager:location_info(id)
			return arclib.itemvis.standard_flags(info)
		end,
		piredo_get_desc = function(pos)
			local id = core.get_meta(pos):get_float(modname)
			local info = api.manager:location_info(id)
			local lines = {
				info.location_name or "",
				info.receiving_player_name or "",
			}
			if info.hint_status and info.item_name then
				lines[#lines + 1] = info.item_name
			end
			if info.hint_status and info.hint_status ~= "unspecified" then
				lines[#lines + 1] = string_upper(info.hint_status)
			end
			if info.item_flags and info.item_flags.progression then
				lines[#lines + 1] = "PROGRESSION"
			end
			if info.hint_status and info.item_flags then
				for _, k in ipairs({"useful", "trap"}) do
					if info.item_flags[k] then
						lines[#lines + 1] = string_upper(k)
					end
				end
			end
			return table_concat(lines, "\n")
		end
	})

arclib.itemvis.node_register({myname})
