-- LUALOCALS < ---------------------------------------------------------
local get_mod_api, minetest
    = get_mod_api, minetest
-- LUALOCALS > ---------------------------------------------------------

local api = get_mod_api()
local modname = minetest.get_current_modname()

local getdata = api.create_player_data()

api.register_on_playerswap(function(newp, oldp)
		if newp then
			local ndata = getdata(newp)
			ndata.hud = ndata.hud or newp:hud_add({
					hud_elem_type = "compass",
					size = {x = 96, y = 96},
					text = modname .. "_compass.png",
					position = {x = 0.5, y = 0.5},
					alignment = {x = 0, y = 0},
					offset = {x = 0, y = 0},
					direction = 1
				})
		end
		if oldp then
			local odata = getdata(oldp)
			if odata.hud then oldp:hud_remove(odata.hud) end
		end
	end)
