-- LUALOCALS < ---------------------------------------------------------
local minetest, piredo_player, vector
    = minetest, piredo_player, vector
-- LUALOCALS > ---------------------------------------------------------

-- Specifically for the barriers uses as a "glass floor" in
-- the special "final" room, so players can see that they
-- won't actually fall through.

minetest.register_abm({
		nodenames = {"piredo_terrain:piranesi__barrier"},
		interval = 1,
		chance = 1,
		action = function(pos, node)
			if node.param2 ~= 1 then
				local mp = piredo_player.mainplayer()
				local ppos = mp and mp:get_pos()
				if not ppos
				or pos.x < ppos.x - 1.5
				or pos.x > ppos.x + 1.5
				or pos.z < ppos.z - 1.5
				or pos.z > ppos.z + 1.5
				or pos.y < ppos.y - 1.5
				or pos.y > ppos.y + 3.5
				then return end
			end
			return minetest.add_particlespawner({
					amount = 10,
					time = 2,
					minpos = vector.offset(pos, -0.5, -0.5, -0.5),
					maxpos = vector.offset(pos, 0.5, 0.5, 0.5),
					minexptime = 1,
					maxexptime = 2,
					minsize = 0,
					maxsize = 0.25,
					texture = "[combine:1x1^[noalpha^[invert:rgb"
				})
		end
	})
