-- LUALOCALS < ---------------------------------------------------------
local ipairs, minetest, piredo_api, piredo_schems, table
    = ipairs, minetest, piredo_api, piredo_schems, table
local table_concat
    = table.concat
-- LUALOCALS > ---------------------------------------------------------

local modname = minetest.get_current_modname()
local api = piredo_api.get_mod_api()

local formname = modname .. "_forceroom"

local roomform
local roomlookup = {}
do
	local rooms = {}
	local function addrooms(prefix)
		for _, k in ipairs(api.find_schematics(prefix)) do
			local v = piredo_schems[k]
			local d = (v.internal_name or v.title or k)
			d = minetest.formspec_escape(d)
			rooms[#rooms + 1] = d
			roomlookup["DCL:" .. #rooms] = k
		end
	end
	addrooms("normal")
	addrooms("large")
	addrooms("quad_hall")
	addrooms("special_candle")
	addrooms("special_final")
	addrooms("mystery")
	roomform = "size[8,12]textlist[0,0;8,12;room;" .. table_concat(rooms, ",") .. "]"
end

minetest.register_chatcommand("room", {
		description = "force next room",
		privs = {give = true},
		func = function(pname)
			return minetest.show_formspec(pname, formname, roomform)
		end
	})

minetest.register_on_player_receive_fields(function(player, fname, fields)
		if fname ~= formname or not minetest.check_player_privs(player, "give")
		then return end

		local room = fields.room and roomlookup[fields.room]
		if not room then return end

		api.statedb.forced = room
		api.savedb()

		minetest.close_formspec(player:get_player_name(), formname)
		minetest.chat_send_player(player:get_player_name(), "next room: " .. room)
	end)
