-- LUALOCALS < ---------------------------------------------------------
local minetest, piredo_api
    = minetest, piredo_api
-- LUALOCALS > ---------------------------------------------------------

local api = piredo_api.get_mod_api()
local modstore = minetest.get_mod_storage()

local stopkey = "timer_stopped"
local stopped = modstore:get_string(stopkey) ~= ""

local timerkey = "total_elapsed"
local timer = modstore:get_float(timerkey)
api.timer = timer

local sessionkey = "total_sessions"
local sessions = modstore:get_float(sessionkey)
api.sessions = sessions

function api.stop_timer()
	stopped = true
	modstore:set_string(stopkey, "1")
end

function api.is_timer_stopped() return stopped end

local lasttime
minetest.register_globalstep(function()
		local now = minetest.get_us_time() / 1000000
		if lasttime and not stopped then
			timer = timer + now - lasttime
			modstore:set_float(timerkey, timer)
		end
		lasttime = now
		api.timer = timer
	end)

minetest.register_on_joinplayer(function(player)
		if stopped then return end
		local pname = player:get_player_name()
		local _, mname = api.mainplayer()
		if pname ~= mname then return end
		sessions = sessions + 1
		modstore:set_float(sessionkey, sessions)
		api.sessions = sessions
	end)
