-- LUALOCALS < ---------------------------------------------------------
local math, tonumber
    = math, tonumber
local math_floor
    = math.floor
-- LUALOCALS > ---------------------------------------------------------

-- luacheck: push
-- luacheck: globals config readtext readbinary

readtext = readtext or function() end
readbinary = readbinary or function() end

local stamp = tonumber("$Format:%at$")
if not stamp then return end
stamp = math_floor((stamp - 1540612800) / 60)
stamp = ("00000000" .. stamp):sub(-8)

return {
	user = "Warr1024",
	pkg = "puzzlemap",
	min = "5.0",
	version = stamp .. "-$Format:%h$",
	path = ".",
	type = "mod",
	title = "PuzzleMap",
	short_desc = "Puzzle/Adventure Map System using Node Protection Mechanic",
	tags = "creative, puzzle",
	license = "mit",
	desc = readtext('README.md'),
	repo = "https://gitlab.com/sztest/puzzlemap",
	screenshots = {readbinary('.cdbscreen.jpg')}
}

-- luacheck: pop
