-- LUALOCALS < ---------------------------------------------------------
local minetest, string
    = minetest, string
local string_format
    = string.format
-- LUALOCALS > ---------------------------------------------------------

-- Chat command to completely destroy a player account, including auth.
minetest.register_chatcommand("destroy_player", {
		params = "<playername>",
		description = "Completely destroy a player account",
		privs = {privs = true},
		func = function(name, param)
			if not minetest.player_exists(param) then
				return false, "Player not found"
			end
			if minetest.check_player_privs(param, "privs") then
				return false, "Cannot delete an admin account"
			end
			if minetest.get_player_by_name(param) then
				minetest.kick_player(param, "Account deleted")
			end
			minetest.remove_player(param)
			minetest.remove_player_auth(param)
			minetest.log("warning", string_format(
					"player account %q was destroyed by %q",
					param, name))
			return true, string_format("Player %q destroyed", param)
		end
	})

-- Moderators and admins can always bypass player limits,
-- important for emergency access.
minetest.register_can_bypass_userlimit(function(name)
		local privs = minetest.get_player_privs(name)
		return privs.privs or privs.basic_privs
	end)
