This mod adds "telecode" related commands, which allows teleportation by code.

- `/tc` gets the telecode for the current location.
- `/tc <code>` teleports to the specified location.

Teleportation codes, i.e. "telecodes", are 16-digit hex numbers which contain an encrypted position (rounded to center of node) and an authentication checksum.  They are effectively opaque to players, and cannot be guessed, decoded, modified, or compared (other than exact equality) without knowing the server's private encryption key.  Keys are per-server/per-world, so telecodes from one world, or from single player, cannot be used on a different server.

The mod also provides some bookmarking capabilities so players only need to deal with the codes when they want to share/publish them.

- `/tcsave <name>` - save current location to a bookmark.
- `/tcsave <name> [code]` - save location from telecode as bookmark.
- `/tcls` - list all bookmarks
- `/tcls <search>` - list all bookmarks matching search
- `/trcm <name>` - remove a bookmark
- `/tcsend * <name>` - share a bookmark with everyone via chat
- `/tcsend <player> <name>` - share a bookmark with player via DM
- `/tcsend *` - share current location telecode with everyone
- `/tcsend <player>` - send current location to player via DM

Players must be able to physically travel to a location to find the telecode for it, but may then later freely travel to that location at any time, and/or share the code with anyone they want via any means at their disposal, such as in-game chat, posting on wikis/forums, etc.

Valid new telecodes that are received via chat or DM are automatically saved in bookmarks, named `^`, `^2`, `^3`, `^4`, and `^5`, in order of most recently received, except for any telecodes already bookmarked. These special bookmarks can also be used in the place of an explicit code for /tcsave.

