-- LUALOCALS < ---------------------------------------------------------
local ipairs, minetest, string, table
    = ipairs, minetest, string, table
local string_format, table_concat, table_remove
    = string.format, table.concat, table.remove
-- LUALOCALS > ---------------------------------------------------------

-- Chat command to completely destroy a player account, including auth.
minetest.register_chatcommand("destroy_player", {
		params = "<playername>",
		description = "Completely destroy a player account",
		privs = {privs = true},
		func = function(name, param)
			if not minetest.player_exists(param) then
				return false, "Player not found"
			end
			if minetest.check_player_privs(param, "privs") then
				return false, "Cannot delete an admin account"
			end
			if minetest.get_player_by_name(param) then
				return false, "Cannot delete online players"
			end
			minetest.remove_player(param)
			minetest.remove_player_auth(param)
			minetest.log("warning", string_format(
					"player account %q was destroyed by %q",
					param, name))
			return true, string_format("Player %q destroyed", param)
		end
	})

-- Chat command to write to the server log.
do
	local allowed = {"verbose", "info", "action", "warning", "error"}
	local allowed_idx = {}
	for _, v in ipairs(allowed) do allowed_idx[v] = true end
	local allowed_str = table_concat(allowed, ", ")
	minetest.register_chatcommand("log", {
			params = "<severity> <message>",
			description = "Write any message to server log",
			privs = {server = true},
			func = function(name, param)
				local words = param:split(" ")
				local severity = words[1]
				table_remove(words, 1)
				if not allowed_idx[severity] then
					return false, "severity must be one of " .. allowed_str
				end
				minetest.log("action", name .. " used the log command")
				minetest.log(severity, table_concat(words, " "))
			end
		})
end

-- Moderators and admins can always bypass player limits,
-- important for emergency access.
minetest.register_can_bypass_userlimit(function(name)
		local privs = minetest.get_player_privs(name)
		return privs.privs or privs.basic_privs
	end)
