-- LUALOCALS < ---------------------------------------------------------
local core, string, tonumber
    = core, string, tonumber
local string_format
    = string.format
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()

local max = tonumber(core.settings:get(modname .. "_max")) or 2

local lag = 0
local last = core.get_us_time()
core.register_globalstep(function()
		if lag <= 0 then return end
		local exp = last + lag * 1000000
		while core.get_us_time() < exp do end
		last = exp
	end)

core.register_chatcommand("lag", {
		description = "Set server minimum lag amount",
		params = "<seconds_per_step>",
		privs = {server = true},
		func = function(_, param)
			param = tonumber(param)
			if not param then return false, "invalid number" end
			if param < 0 then param = 0 end
			if param > max then param = max end
			lag = param
			return true, string_format("Lag set to at least %0.3fs per step", lag)
		end
	})
