-- LUALOCALS < ---------------------------------------------------------
local core, math, pairs, table, tonumber, tostring
    = core, math, pairs, table, tonumber, tostring
local math_random, table_concat, table_remove, table_sort
    = math.random, table.concat, table.remove, table.sort
-- LUALOCALS > ---------------------------------------------------------

local modname = core.get_current_modname()
local modstore = core.get_mod_storage()

local timedelay = tonumber(core.settings:get(modname .. "_time")) or 300
local linedelay = tonumber(core.settings:get(modname .. "_lines")) or 25
local maxnames = tonumber(core.settings:get(modname .. "_names")) or 50

local stpriv = core.settings:get(modname .. "_hide") or "stealth"
local function isstealth(p) return core.check_player_privs(p, stpriv) end

local lines = 0
local exp = 0

local anyonline = modstore:get_string("online") ~= ""
local function setanyonline(val)
	if anyonline == val then return end
	anyonline = val
	return modstore:set_string("online", val and "1" or "")
end

local function announce()
	local names = {}
	for _, player in pairs(core.get_connected_players()) do
		if not isstealth(player) then
			names[#names + 1] = player:get_player_name()
		end
	end
	table_sort(names)

	local more = 0
	while #names > maxnames do
		table_remove(names, math_random(1, #names))
		more = more + 1
	end
	if more > 0 then
		names[#names + 1] = "(" .. more .. " more)"
	end

	if #names > 0 then
		core.chat_send_all("*** Online: " .. table_concat(names, ", "))
		setanyonline(true)
	else
		core.chat_send_all("*** Server is empty.")
		setanyonline(false)
	end
end

local function sendall(isann)
	lines = lines + 1
	if not isann then return end

	local now = core.get_us_time() / 1000000
	if (lines < linedelay) and (now < exp) then return end
	exp = now + timedelay
	lines = 0

	core.after(0, announce)
end

if anyonline then sendall(true) end

do
	local old_sendall = core.chat_send_all
	function core.chat_send_all(text, ...)
		sendall(tostring(text):match("^%s*%*%*%*%s"))
		return old_sendall(text, ...)
	end
end

core.register_on_chat_message(function(pname, text)
		if text:sub(1, 1) ~= "/"
		and core.check_player_privs(pname, "shout") then
			sendall()
		end
	end)
