local COOLDOWN_STRAFE = 1.0
local STRAFE_POWER = 14

local strafe_timer = COOLDOWN_STRAFE + 1

core.register_globalstep(function(dtime)
	local players = core.get_connected_players()
	if strafe_timer < COOLDOWN_STRAFE then
		strafe_timer = strafe_timer + dtime
		return
	end
	for p=1, #players do
		local player = players[p]
		local ctrl = player:get_player_control()

		-- Aux1 + direction key: Boost to that direction
		if ctrl.aux1 then
			if ctrl.left or ctrl.right or ctrl.up or ctrl.down then
				local boost = vector.new(0,0,STRAFE_POWER)
				local yaw = player:get_look_horizontal()
				if ctrl.left then
					yaw = yaw + math.pi/2
				elseif ctrl.right then
					yaw = yaw - math.pi/2
				elseif ctrl.down then
					yaw = yaw - math.pi
				end
				boost = vector.rotate_around_axis(boost, vector.new(0,1,0), yaw)
				player:add_velocity(boost)
				strafe_timer = 0
				strafe_timer = 0
			end
		end
	end
end)
