local SPAWN_POS = vector.new(0, 3.5, 0)
local DEFAULT_FOV = 92
local PITCH_MIN_VISIBLE = -0.6154
local PITCH_MAX_VISIBLE = 0.8570

local OPACITY = "95"
local TEXTURES = {"cow_player_cow.png"}
local TEXTURES_TRANSLUCENT = {"cow_player_cow.png^[opacity:"..OPACITY}

local TEXTURES_DAMAGED = {"cow_player_cow_damaged.png"}
local TEXTURES_DAMAGED_TRANSLUCENT = {"cow_player_cow_damaged.png^[opacity:"..OPACITY}

local TEXTURES_DEAD = {"cow_player_cow_dead.png"}
local TEXTURES_DEAD_TRANSLUCENT = {"cow_player_cow_dead.png^[opacity:"..OPACITY}

cow_player = {}

local texture_mode = "normal"

local update_textures = function(player)
	local pitch = player:get_look_vertical()
	local props = player:get_properties()
	local old_use_texture_alpha = props.use_texture_alpha == true
	local old_textures = props.textures

	local new_use_texture_alpha = false
	local new_textures = TEXTURES

	-- No translucency in third-person front mode
	if player:get_camera().mode == "third_front" then
		new_use_texture_alpha = false
	-- Make model translucent at certain view angles so we can still see where we're aiming
	elseif pitch > PITCH_MAX_VISIBLE or pitch < PITCH_MIN_VISIBLE then
		new_use_texture_alpha = true
	else
		new_use_texture_alpha = false
	end

	if texture_mode == "normal" then
		if new_use_texture_alpha then
			new_textures = TEXTURES_TRANSLUCENT
		else
			new_textures = TEXTURES
		end
	elseif texture_mode == "damaged" then
		if new_use_texture_alpha then
			new_textures = TEXTURES_DAMAGED_TRANSLUCENT
		else
			new_textures = TEXTURES_DAMAGED
		end
	elseif texture_mode == "dead" then
		if new_use_texture_alpha then
			new_textures = TEXTURES_DEAD_TRANSLUCENT
		else
			new_textures = TEXTURES_DEAD
		end
	else
		core.log("error", "[cow_player] Unsupported texture mode: "..tostring(mode))
		return
	end
	if old_use_texture_alpha ~= new_use_texture_alpha or old_textures[1] ~= new_textures[1] then
		player:set_properties({textures = new_textures, use_texture_alpha = new_use_texture_alpha})
	end
end

cow_player.set_texture_mode = function(player, mode)
	if mode == "damaged" or mode == "normal" or mode == "dead" then
		texture_mode = mode
		update_textures(player)
	else
		core.log("error", "[cow_player] Unsupported texture mode: "..tostring(mode))
	end
end

core.register_on_newplayer(function(player)
	player:set_pos(SPAWN_POS)
end)
core.register_on_joinplayer(function(player)
	player:set_fov(DEFAULT_FOV)
	player:set_properties({
		collisionbox = { -0.9, 0, -0.9, 0.9, 1.6, 0.9 } ,
		selectionbox = { -0.9, 0, -0.9, 0.9, 1.6, 0.9 } ,
		visual_size = { x = 10, y = 10 },
		visual = "mesh",
		mesh = "cow_player_cow.glb",
		textures = TEXTURES,
		backface_culling = true,
		use_texture_alpha = false,
		eye_height = 1.40,
	})
	player:set_eye_offset(vector.new(0, 0, 0), vector.new(0, 5, 5), vector.new(0, 9.5, -5))
	local inv = player:get_inventory()
	inv:set_size("craft", 0)
	inv:set_size("craftpreview", 0)
	inv:set_size("craftresult", 0)
	local wieldhand, hotbar
	if not core.is_creative_enabled(player:get_player_name()) then
		player:set_pos(SPAWN_POS)
		wieldhand = false
		hotbar = false
		player:set_inventory_formspec("")
		player:hud_set_hotbar_itemcount(1)
		inv:set_size("main", 0)
		player:set_camera({mode="third"})
	else
		player:set_inventory_formspec("formspec_version[6]size[10.75,5.75]list[current_player;main;0.5,0.5;8,4]")
	end
	player:hud_set_flags({
		minimap = false,
		minimap_radar = false,
		wielditem = wieldhand,
		hotbar = hotbar,
	})
	player:set_physics_override({
		sneak = false,
	})
end)

core.register_globalstep(function(dtime)
	local players = core.get_connected_players()
	for p=1, #players do
		local player = players[p]
		update_textures(player)
	end
end)
