core.register_on_joinplayer(function(player)
	player:set_sun({visible=true, sunrise_visible=false})
	player:set_moon({visible=false})
	player:set_stars({visible=false})
	player:set_clouds({
		density=0.3,
		height=150,
		thickness=5,
		shadow="#c3d5c7",
		color="#ebecdc",
		speed={x=2,y=2}
	})
	player:set_sky({
		type = "regular",
		clouds = true,
		sky_color = {
			day_sky = "#2485a6",
			day_horizon = "#2485a6",
			dawn_sky = "#284261",
			dawn_horizon = "#284261",
			night_sky = "#232228",
			night_horizon = "#232228",
			indoors = "#322228",
		},
		fog = {
			fog_distance = 900,
			fog_start = 0.7,
			fog_color = "#2485a6",
		},
	})
end)


-- Force timeofday to always stay within daytime
local TIMEOFDAY_START = 0.26
local TIMEOFDAY_END = 0.72

local timer = 0
minetest.register_globalstep(function(dtime)
	timer = timer + dtime
        if timer >= 2.5 then
		timer = 0
		local tod = core.get_timeofday()
		if tod > TIMEOFDAY_END or tod < TIMEOFDAY_START then
			core.set_timeofday(TIMEOFDAY_START)
			core.log("action", "[cow_sky] Reset timeofday")
		end
        end
end)
