cow_highscore = {}

local S = core.get_translator("cow_highscore")

local mod_storage = core.get_mod_storage()

cow_highscore.get_highscore = function()
	local highscore = mod_storage:get_int("highscore_1")
	if highscore < 0 then
		highscore = 0
	end
	return highscore
end
cow_highscore.send_new_score = function(score)
	local highscore = cow_highscore.get_highscore()
	if score > highscore then
		mod_storage:set_int("highscore_1", score)
		core.log("action", "[cow_highscore] New highscore: "..score)
		return true
	else
		return false
	end
end
cow_highscore.reset_highscore = function()
	mod_storage:set_int("highscore_1", 0)
	core.log("action", "[cow_highscore] Highscore reset to 0")
end

core.register_chatcommand("reset_highscore", {
	description = S("Reset the highscore"),
	privs = {},
	params = "",
	func = function(name, param)
		cow_highscore.reset_highscore()
		return true, S("Highscore reset.")
	end,
})
