cow_holder = {}

-- Invisible entity to hold the player in place
-- at the start of the game.
-- To use it, attach the player to this entity.
core.register_entity("cow_holder:player_holder", {
	initial_properties = {
		physical = false,
		collide_with_objects = false,
		pointable = false,
		static_save = false,
		-- Must be set to true so that attached player is visible, too.
		is_visible = true,
		-- The invisibility of this object comes from the blank textures
		textures = { "blank.png", "blank.png" },
	},
	_timer = 0,
	on_activate = function(self)
		self.object:set_armor_groups({immortal=1})
		core.log("info", "[cow_holder] Player holder spawned @ "..core.pos_to_string(self.object:get_pos()))
	end,
	on_step = function(self, dtime)
		-- Periodically check if player holder actually has any objects attached to
		-- it and despawn it if not.
		self._timer = self._timer + dtime
		if self._timer >= 5 then
			if #self.object:get_children() == 0 then
				core.log("warning", "[cow_object] Unused player holder removed @ "..core.pos_to_string(self.object:get_pos()))
				self.object:remove()
				return
			end
			self._timer = 0
		end
	end,
	on_deactivate = function(self)
		core.log("info", "[cow_holder] Player holder despawned @ "..core.pos_to_string(self.object:get_pos()))
	end,
	on_attach_child = function(self, child)
		core.log("info", "[cow_holder] Object '"..tostring(child:get_guid()).."' attached to player holder @ "..core.pos_to_string(self.object:get_pos()))
	end,
	on_detach_child = function(self, child)
		core.log("info", "[cow_holder] Object '"..tostring(child:get_guid()).."' detached from player holder @ "..core.pos_to_string(self.object:get_pos()))
	end,
})

function cow_holder.hold_player(player)
	if player:get_attach() then
		return false
	end
	local pos = player:get_pos()
	local yaw = player:get_look_horizontal()
	local ent = core.add_entity(pos, "cow_holder:player_holder")
	ent:set_yaw(yaw)
	local deg = 360 - (yaw / (math.pi*2))*360
	player:set_attach(ent, nil, nil, { x=0, y=deg, z=0 })
	core.log("action", "[cow_holder] Player '"..player:get_player_name().."' has been captured by player holder")
	return true
end
function cow_holder.unhold_player(player)
	local parent = player:get_attach()
	if parent then
		local lua = parent:get_luaentity()
		if lua.name == "cow_holder:player_holder" then
			player:set_detach()
			parent:remove()
			core.log("action", "[cow_holder] Player '"..player:get_player_name().."' has been released from player holder")
			return true
		end
	end
	return false
end

