local COOLDOWN_BOOST = 5.0
local COOLDOWN_SUPERBOOST = 0.5
local BOOST_POWER = 14

local boost_timer = -1

core.register_globalstep(function(dtime)
	local state = cow_game.get_state()
	if boost_timer < 0 then
		if state == cow_game.STATE_PLAY then
			-- When entering the play state, initlaize the boost
			-- timer shortly before the boost activates.
			-- Works around an issue that the boost does not
			-- always trigger when the player wants to activate
			-- it immediately after start.
			boost_timer = math.max(1.0, COOLDOWN_BOOST - 0.1)
		else
			return
		end
	end
	local players = core.get_connected_players()
	if state ~= cow_game.STATE_PLAY then
		boost_timer = -1
		for p=1, #players do
			cow_gui.hide_boost(players[p])
		end
		return
	end
	local superboost = cow_game.get_superboost()
	if (not superboost and boost_timer < COOLDOWN_BOOST) or (superboost and boost_timer < COOLDOWN_SUPERBOOST) then
		boost_timer = boost_timer + dtime
		return
	end
	for p=1, #players do
		local player = players[p]
		local ctrl = player:get_player_control()

		-- Aux1 + direction key: Boost to that direction
		if ctrl.aux1 then
			local boosted = false
			if ctrl.left or ctrl.right or ctrl.up or ctrl.down then
				local boost = vector.new(0,0,BOOST_POWER)
				local yaw = player:get_look_horizontal()
				if ctrl.left then
					yaw = yaw + math.pi/2
				elseif ctrl.right then
					yaw = yaw - math.pi/2
				elseif ctrl.down then
					yaw = yaw - math.pi
				end
				boost = vector.rotate_around_axis(boost, vector.new(0,1,0), yaw)
				player:add_velocity(boost)
				boost_timer = 0
				boosted = true
				core.sound_play({name="cow_movement_boost", gain=0.9}, {to_player=player:get_player_name()}, true)
			end
			if boosted then
				cow_gui.show_boost(player, "recharging")
			else
				cow_gui.show_boost(player, "arming")
			end
		else
			cow_gui.show_boost(player, "ready")
		end
	end
end)
