cow_locale = {}

local supported_languages = {
	["de"] = true,
}
local use_english = {
	["de"] = {
		["cow_menu_header"] = true,
		["cow_gui_game_over"] = true,
		["cow_gui_countdown_3"] = true,
		["cow_gui_countdown_2"] = true,
		["cow_gui_countdown_1"] = true,
		["cow_highscore_highscore"] = true,
		["cow_highscore_highscore_flashing"] = true,
	},
}

cow_locale.get_localized_image = function(player, image_name)
	local pinfo = core.get_player_information(player:get_player_name())
	local lang = pinfo.lang_code
	if not supported_languages[lang] then
		return image_name
	end
	local base_name = string.sub(image_name, 1, -5)
	if use_english[lang][base_name] then
		return image_name
	end
	image_name = base_name .. "." .. lang .. ".png"
	return image_name
end
