local S = core.get_translator("cow_core")

core.register_node("cow_core:stone", {
	description = S("Stone"),
	tiles = { "cow_core_stone.png" },
})

core.register_node("cow_core:grass_block", {
	description = S("Grass Block"),
	tiles = {
		{name="cow_core_grass.png", align_style="world", scale=4},
		{name="cow_core_grass.png", align_style="world", scale=4},
		"cow_core_grass_side.png",
	},
	groups = { bouncy = -100 }
})
core.register_node("cow_core:grass_dirt_block", {
	description = S("Dirt with Grass"),
	tiles = {
		"cow_core_grass_dark.png",
		"cow_core_dirt.png",
		"cow_core_grass_block_side.png",
		"cow_core_grass_block_side.png",
		"cow_core_grass_block_side.png",
		"cow_core_grass_block_side.png",
	},
	groups = { bouncy = -100 },
})

core.register_node("cow_core:grass_flower_block", {
	description = S("Grass Block with Flowers"),
	tiles = {
		"cow_core_grass_flowers.png",
		"cow_core_grass_flowers.png",
		"cow_core_grass_side.png",
	},
	groups = { bouncy = -100 }
})

core.register_node("cow_core:dirt", {
	description = S("Dirt"),
	tiles = { "cow_core_dirt.png" },
	groups = { bouncy = -100 },
})

-- Non-bouncy dirt
core.register_node("cow_core:hard_dirt", {
	description = S("Hard Dirt"),
	tiles = { "cow_core_dirt.png" },
})

core.register_node("cow_core:dirt_tilled", {
	description = S("Tilled Dirt"),
	tiles = { "cow_core_dirt_tilled.png", "cow_core_dirt.png" },
	groups = { bouncy = -100 },
})

core.register_node("cow_core:gravel_path", {
	description = S("Gravel Path"),
	paramtype = "light",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 7/16, 0.5 },
	},
	tiles = {
		"cow_core_gravel_path.png",
		"cow_core_dirt.png",
		"cow_core_gravel_path_side.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:dirt_path", {
	description = S("Dirt Path"),
	paramtype = "light",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 7/16, 0.5 },
	},
	tiles = {
		"cow_core_dirt_path.png",
		"cow_core_dirt.png",
		"cow_core_dirt_path_side.png",
	},
	groups = { bouncy = -100 },
})



core.register_node("cow_core:fence", {
	description = S("Wooden Fence"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	tiles = {
		"cow_core_fence_top.png",
		"cow_core_fence_top.png",
		"cow_core_fence_side.png",
	},
	node_box = {
		type = "connected",
		fixed = {-1/8, -1/2, -1/8, 1/8, 1/2, 1/8},
			connect_front = {{-1/16,  3/16, -1/2,   1/16,  5/16, -1/8 },
				{-1/16, -5/16, -1/2,   1/16, -3/16, -1/8 }},
			connect_left =  {{-1/2,   3/16, -1/16, -1/8,   5/16,  1/16},
				{-1/2,  -5/16, -1/16, -1/8,  -3/16,  1/16}},
			connect_back =  {{-1/16,  3/16,  1/8,   1/16,  5/16,  1/2 },
				{-1/16, -5/16,  1/8,   1/16, -3/16,  1/2 }},
			connect_right = {{ 1/8,   3/16, -1/16,  1/2,   5/16,  1/16},
				{ 1/8,  -5/16, -1/16,  1/2,  -3/16,  1/16}
		},
	},
	connects_to = { "group:fence", "group:concrete" },
	collision_box = {
		type = "regular",
	},
	groups = { bouncy = -100, fence = 1 }
})

core.register_node("cow_core:water", {
	description = S("Water"),
	paramtype = "light",
	drawtype = "liquid",
	walkable = false,
	tiles = {
		"cow_core_water.png",
		"cow_core_water.png",
	},
	post_effect_color = { r = 48, g = 90, b = 205, a = 195 },
	use_texture_alpha = "blend",
})

core.register_node("cow_core:tree_willow", {
	description = S("Willow Tree Trunk"),
	tiles = {
		"cow_core_tree_willow_top.png",
		"cow_core_tree_willow_top.png",
		"cow_core_tree_willow.png",
	},
	paramtype2 = "facedir",
	groups = { bouncy = -100 },
})

core.register_node("cow_core:leaves_willow", {
	description = S("Willow Leaves"),
	paramtype = "light",
	drawtype = "allfaces_optional",
	tiles = {
		"cow_core_leaves_willow.png"
	},
	groups = { bouncy = -100 },
	use_texture_alpha = "clip",
})

core.register_node("cow_core:wood_red", {
	description = S("Red Wood"),
	tiles = {
		"cow_core_wood_red.png"
	},
	groups = { bouncy = -100, wood = 1 },
})
core.register_node("cow_core:wood_brown", {
	description = S("Brown Wood"),
	tiles = { "cow_core_wood_brown.png" },
	groups = { bouncy = -100, wood = 1 },
})

core.register_node("cow_core:roof", {
	description = S("Roof Tiles Block"),
	tiles = {
		"cow_core_roof.png"
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:roof_angled", {
	description = S("Angled Roof Tiles"),
	paramtype = "light",
	paramtype2 = "4dir",
	drawtype = "nodebox",
	tiles = {
		{ name = "cow_core_roof.png", align_style = "world" },
		{ name = "cow_core_roof.png", align_style = "world" },
		"cow_core_roof.png",
	},
	node_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
			{ -0.5, 0, 0, 0.5, 0.5, 0.5 },
		},
	},
	groups = { bouncy = -100 },
})



core.register_node("cow_core:hay_bale", {
	description = S("Hay Bale"),
	paramtype2 = "facedir",
	tiles = {
		"cow_core_hay_bale_top.png",
		"cow_core_hay_bale_top.png",
		"cow_core_hay_bale_side.png",
	},
	groups = { bouncy = -100 },
})

-- House nodes
core.register_node("cow_core:glass", {
	description = S("Glass"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "glasslike",
	tiles = {
		"cow_core_glass.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:door_wood_top", {
	description = S("Wooden Door (top segment)"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	tiles = {
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_top.png^[transformFX",
		"cow_core_door_wood_top.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
	},
	use_texture_alpha = "clip",
	groups = { bouncy = -100 },
})
core.register_node("cow_core:door_wood_bottom", {
	description = S("Wooden Door (bottom segment)"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	tiles = {
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_sides.png",
		"cow_core_door_wood_bottom.png^[transformFX",
		"cow_core_door_wood_bottom.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
	},
	use_texture_alpha = "clip",
	groups = { bouncy = -100 },
})
core.register_node("cow_core:door_carbon_steel_top", {
	description = S("Carbon Steel Door (top segment)"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	tiles = {
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_top.png^[transformFX",
		"cow_core_door_carbon_steel_top.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
	},
	use_texture_alpha = "clip",
	groups = { bouncy = -100 },
})
core.register_node("cow_core:door_carbon_steel_bottom", {
	description = S("Carbon Steel Door (bottom segment)"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	tiles = {
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_sides.png",
		"cow_core_door_carbon_steel_bottom.png^[transformFX",
		"cow_core_door_carbon_steel_bottom.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, -7/16 },
	},
	use_texture_alpha = "clip",
	groups = { bouncy = -100 },
})

-- Furniture

core.register_node("cow_core:fridge_top", {
	description = S("Fridge (top segment)"),
	paramtype2 = "4dir",
	tiles = {
		"cow_core_fridge_topbottom.png",
		"cow_core_fridge_topbottom.png",
		"cow_core_fridge_top_sides.png",
		"cow_core_fridge_top_sides.png",
		"cow_core_fridge_top_sides.png",
		"cow_core_fridge_top_front.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:fridge_bottom", {
	description = S("Fridge (bottom segment)"),
	paramtype2 = "4dir",
	tiles = {
		"cow_core_fridge_topbottom.png",
		"cow_core_fridge_topbottom.png",
		"cow_core_fridge_bottom_sides.png",
		"cow_core_fridge_bottom_sides.png",
		"cow_core_fridge_bottom_sides.png",
		"cow_core_fridge_bottom_front.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:locker_top", {
	description = S("Locker (top segment)"),
	paramtype2 = "4dir",
	tiles = {
		"cow_core_locker_topbottom.png",
		"cow_core_locker_topbottom.png",
		"cow_core_locker_top_sides.png",
		"cow_core_locker_top_sides.png",
		"cow_core_locker_top_sides.png",
		"cow_core_locker_top_front.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:locker_bottom", {
	description = S("Locker (bottom segment)"),
	paramtype2 = "4dir",
	tiles = {
		"cow_core_locker_topbottom.png",
		"cow_core_locker_topbottom.png",
		"cow_core_locker_bottom_sides.png",
		"cow_core_locker_bottom_sides.png",
		"cow_core_locker_bottom_sides.png",
		"cow_core_locker_bottom_front.png",
	},
	groups = { bouncy = -100 },
})

core.register_node("cow_core:television", {
	description = S("Television"),
	paramtype2 = "4dir",
	tiles = {
		"cow_core_television_sides.png",
		"cow_core_television_sides.png",
		"cow_core_television_sides.png",
		"cow_core_television_sides.png",
		"cow_core_television_sides.png",
		{ name = "cow_core_television_front_animated.png", animation = { type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 1 } },
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:shelf_empty", {
	description = S("Empty Shelf"),
	paramtype2 = "4dir",
	tiles = {
		"cow_core_shelf_sides.png",
		"cow_core_shelf_sides.png",
		"cow_core_shelf_sides.png",
		"cow_core_shelf_sides.png",
		"cow_core_shelf_sides.png",
		"cow_core_shelf_empty_front.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:bookshelf", {
	description = S("Bookshelf"),
	paramtype2 = "4dir",
	tiles = {
		"cow_core_shelf_sides.png",
		"cow_core_shelf_sides.png",
		"cow_core_shelf_sides.png",
		"cow_core_shelf_sides.png",
		"cow_core_shelf_sides.png",
		"cow_core_shelf_books_front.png",
	},
	groups = { bouncy = -100 },
})
local curtains = {
	{ "white", S("White Curtain") },
	{ "red", S("Red Curtain") },
	{ "blue", S("Blue Curtain") },
	{ "green", S("Green Curtain") },
}
for c=1, #curtains do
	local id = curtains[c][1]
	local desc = curtains[c][2]
	core.register_node("cow_core:curtain_"..id, {
		description = desc,
		drawtype = "nodebox",
		paramtype = "light",
		paramtype2 = "4dir",
		sunlight_propagates = true,
		walkable = false,
		node_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, 15/32, 0.5, 0.5, 0.5 },
		},
		tiles = {
			"blank.png",
			"blank.png",
			"blank.png",
			"blank.png",
			"cow_core_curtain_"..id..".png",
		},
		use_texture_alpha = "clip",
	})
end
core.register_node("cow_core:radiator", {
	description = S("Radiator"),
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "4dir",
	node_box = {
		type = "fixed",
		fixed = { -6/16, -7/16, 6/16, 6/16, 1/16, 0.5 },
	},
	tiles = {
		"cow_core_radiator_top.png",
		"cow_core_radiator_top.png",
		"cow_core_radiator_sides.png",
		"cow_core_radiator_sides.png",
		"cow_core_radiator_front.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:bed_segment", {
	description = S("Bed Segment"),
	drawtype = "nodebox",
	paramtype = "light",
	node_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, -3/16, 0.5 },
		},
	},
	tiles = {
		"cow_core_bed_top.png",
		"cow_core_bed_bottom.png",
		"cow_core_bed_sides.png",
	},
	groups = { bouncy = -100 },
})

core.register_node("cow_core:table", {
	description = S("Table"),
	drawtype = "nodebox",
	paramtype = "light",
	node_box = {
		type = "fixed",
		fixed = {
			{ -0.5, 7/16, -0.5, 0.5, 0.5, 0.5 },
			{ -6/16, -0.5, -6/16, -4/16, 7/16, -4/16 },
			{ 4/16, -0.5, -6/16, 6/16, 7/16, -4/16 },
			{ -6/16, -0.5, 4/16, -4/16, 7/16, 6/16 },
			{ 4/16, -0.5, 4/16, 6/16, 7/16, 6/16 },
		},
	},
	tiles = {
		"cow_core_furniture_wood.png",
		"cow_core_furniture_wood.png",
		"cow_core_furniture_wood_clean.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:chair", {
	description = S("Chair"),
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "4dir",
	node_box = {
		type = "fixed",
		fixed = {
			-- front legs
			{ -5/16, -0.5, -5/16, -4/16, 0, -4/16 },
			{ 4/16, -0.5, -5/16, 5/16, 0, -4/16 },
			-- back legs
			{ 4/16, -0.5, 4/16, 5/16, 0.5, 5/16 },
			{ -5/16, -0.5, 4/16, -4/16, 0.5, 5/16 },
			-- seat
			{ -5/16,-1/16, -5/16, 5/16, 0, 5/16 },
			-- backrest
			{ -4/16, 1/16, 4/16, 4/16, 7/16, 5/16 },
		},
	},
	selection_box = {
		type = "fixed",
		fixed = { -5/16, -0.5, -5/16, 5/16, 0.5, 5/16 },
	},
	tiles = {
		"cow_core_furniture_wood.png",
		"cow_core_furniture_wood.png",
		"cow_core_furniture_wood_clean.png",
	},
	groups = { bouncy = -100 },
})

-- Industrial nodes

-- Glass for the game menu.
-- Should NOT be used anywhere else!
core.register_node("cow_core:industrial_glass", {
	description = S("Industrial Glass"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "glasslike_framed",
	tiles = {
		"cow_core_industrial_glass.png",
		"cow_core_industrial_glass_detail.png",
	},
	-- HACK: Blocks pointing because the player is looking at
	-- this node in the game menu and we want to get rid
	-- of the node highlighting.
	pointable = "blocking",
})

core.register_node("cow_core:lamp", {
	description = S("Lamp"),
	paramtype = "light",
	light_source = 10,
	tiles = {
		"cow_core_lamp.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:safety", {
	description = S("Conrete with Safety Stripes"),
	tiles = {
		"cow_core_safety.png",
		"cow_core_safety.png^[transformR90",
		"cow_core_safety.png^[transformFX",
		"cow_core_safety.png",
		"cow_core_safety.png^[transformFX",
		"cow_core_safety.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:steel_mesh", {
	description = S("Steel Mesh"),
	paramtype = "light",
	drawtype = "allfaces",
	tiles = {
		"cow_core_steel_mesh.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:conveyor_belt", {
	description = S("Conveyor Belt"),
	paramtype2 = "4dir",
	paramtype = "light",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 7/16, 0.5 },
	},
	tiles = {
		{ name = "cow_core_conveyor_belt_top_animated.png", animation = { type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 0.25 } },
		{ name = "cow_core_conveyor_belt_bottom.png" },
		{ name = "cow_core_conveyor_belt_back_animated.png", animation = { type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 0.25 } },
		{ name = "cow_core_conveyor_belt_front_animated.png", animation = { type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 0.25 } },
		{ name = "cow_core_conveyor_belt_sides_animated.png", animation = { type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 0.25 } },
		{ name = "cow_core_conveyor_belt_sides_rev_animated.png", animation = { type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 0.25 } },
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:concrete", {
	description = S("Concrete"),
	tiles = {
		"cow_core_concrete.png",
	},
	groups = { bouncy = -100, concrete = 1 },
})
-- Non-bouncy concrete
core.register_node("cow_core:hard_concrete", {
	description = S("Hard Concrete"),
	tiles = {
		"cow_core_concrete.png",
	},
	groups = { concrete = 1 },
})

core.register_node("cow_core:concrete_white", {
	description = S("White Concrete"),
	tiles = {
		"cow_core_concrete_white.png",
	},
	groups = { bouncy = -100, concrete = 1 },
})

core.register_node("cow_core:chainlink_fence", {
	description = S("Chainlink Fence"),
	tiles = {
		"cow_core_chainlink_top.png", 
		"cow_core_chainlink_top.png^[transformFY", 
		"cow_core_chainlink_sides.png^[transformFX", 
		"cow_core_chainlink_sides.png", 
		"cow_core_chainlink.png", 
	},
	drawtype = "nodebox",
	use_texture_alpha = "clip",
	paramtype2 = "4dir",
	paramtype = "light",
	sunlight_propagates = true,
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -1/16, 0.5, 0.5, 1/16 },
	},
	groups = { bouncy = -100 },
})

core.register_node("cow_core:carbon_steel", {
	description = S("Carbon Steel Block"),
	tiles = {
		"cow_core_carbon_steel.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:carbon_steel_electro_warning", {
	description = S("Carbon Steel Block with High Voltage Sign"),
	paramtype2 = "facedir",
	tiles = {
		"cow_core_carbon_steel.png",
		"cow_core_carbon_steel.png",
		"cow_core_carbon_steel.png",
		"cow_core_carbon_steel.png",
		"cow_core_carbon_steel.png",
		"cow_core_electro_warning.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:cable_box_double", {
	description = S("Cable Box (double-sided)"),
	paramtype2 = "facedir",
	tiles = {
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box.png",
		"cow_core_cable_box.png",
	},
	groups = { bouncy = -100 },
})
core.register_node("cow_core:cable_box_single", {
	description = S("Cable Box (single-sided)"),
	paramtype2 = "facedir",
	tiles = {
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box_sides.png",
		"cow_core_cable_box.png",
	},
	groups = { bouncy = -100 },
})

local cable_selbox
if core.is_creative_enabled("") then
	cable_selbox = {
		type = "fixed",
		fixed = { -4/16, -4/16, -0.5, 4/16, 4/16, 0.5 },
	}
end
core.register_node("cow_core:cable", {
	description = S("Cable"),
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	drawtype = "nodebox",
	tiles = {
		"cow_core_cable.png",
	},
	node_box = {
		type = "fixed",
		fixed = { -1/16, -1/16, -0.5, 1/16, 1/16, 0.5 },
	},
	selection_box = cable_selbox,
	groups = { bouncy = -100 },
})

-- Road blocks

core.register_node("cow_core:asphalt", {
	description = S("Asphalt"),
	tiles = { "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_solid", {
	description = S("Asphalt with Solid Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_solid.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_dashed", {
	description = S("Asphalt with Dashed Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_dashed.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_side", {
	description = S("Asphalt with Side Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_side.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_corner_outer", {
	description = S("Asphalt with Outer Corner Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_corner_outer.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})
core.register_node("cow_core:asphalt_stripe_corner_inner", {
	description = S("Asphalt with Inner Corner Stripe"),
	paramtype2 = "4dir",
	tiles = { "cow_core_asphalt_stripe_corner_inner.png", "cow_core_asphalt.png" },
	groups = { bouncy = -100 },
})

core.register_node("cow_core:sign_steel_post", {
	description = S("Steel Sign Post"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -1/16, -0.5, -1/16, 1/16, 0.5, 1/16 },
	},
	tiles = { "cow_core_sign_steel_post.png" },
	groups = { bouncy = -100 },
})
local road_signs = {
	{"arrow_left", S("Left Arrow") },
	{"arrow_right", S("Right Arrow") },
	{"arrow_up", S("Up Arrow") },
	{"warning", S("Warning") },
	{"wrong_way", S("Wrong Way") },
	{"30", S("Speed Limit 30 km/h") },
	{"60", S("Speed Limit 60 km/h") },
	{"90", S("Speed Limit 90 km/h") },
	{"cow", S("Cow") },
}
for r=1, #road_signs do
	local id = road_signs[r][1]
	local desc = road_signs[r][2]
	core.register_node("cow_core:sign_road_"..id, {
		description = S("Road Sign (@1)", desc),
		tiles = {
			"cow_core_sign_border.png", 
			"cow_core_sign_border.png", 
			"cow_core_sign_border.png", 
			"cow_core_sign_border.png", 
			"cow_core_sign_back.png",
			"cow_core_sign_"..id..".png",
		},
		drawtype = "nodebox",
		paramtype2 = "4dir",
		paramtype = "light",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -1/16, 0.5, 0.5, 1/16 },
		},
		groups = { bouncy = -100, sign_road = 1 },
	})
end
local traffic_lights = {
	{ "green", S("Green"), 30, "yellow" },
	{ "yellow", S("Yellow"), 3, "red" },
	{ "red", S("Red"), 30, "red_yellow" },
	{ "red_yellow", S("Red and Yellow"), 3, "green" },
	{ "off", S("Out of Order") },
}
for t=1, #traffic_lights do
	local id = traffic_lights[t][1]
	local desc = traffic_lights[t][2]
	local timer = traffic_lights[t][3]

	local next_id = traffic_lights[t][4]
	local on_timer, _on_level_init
	if timer then
		local timer_next
		for u=1, #traffic_lights do
			if traffic_lights[u][1] == next_id then
				timer_next = traffic_lights[u][3]
				break
			end
		end
		if not timer_next then
			core.log("error", "[cow_core] Could not get timer for next traffic light phase! (id="..id..")")
			timer_next = 3
		end
		_on_level_init = function(pos)
			local ntimer = core.get_node_timer(pos)
			ntimer:start(timer)
		end
		on_timer = function(pos)
			local node = core.get_node(pos)
			node.name = "cow_core:traffic_lights_"..next_id
			core.set_node(pos, node)
			local timer = core.get_node_timer(pos)
			timer:start(timer_next)
		end
	end
	core.register_node("cow_core:traffic_lights_"..id, {
		description = S("Traffic Lights (@1)", desc),
		tiles = {
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_sides.png", 
			"cow_core_traffic_lights_"..id..".png",
		},
		drawtype = "nodebox",
		paramtype2 = "4dir",
		paramtype = "light",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = { -3/16, -0.5, -3/16, 3/16, 0.5, 2/16 },
		},
		_cow_on_level_init = _on_level_init,
		on_timer = on_timer,
		groups = { needs_level_init = 1, bouncy = -100, traffic_lights = 1 },
	})
end

-- Plants

core.register_node("cow_core:flower_daisy", {
	description = S("Daisy"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	walkable = false,
	tiles = {
		"cow_core_daisy.png"
	},
	waving = 1,
	selection_box = {
		type = "fixed",
		fixed = { -0.4, -0.5, -0.4, 0.4, -3/16, 0.4 },
	},
})

local clumps = {
	[1] = { -4/16 },
	[2] = { -1/16 },
}
for s=1, #clumps do
	local selection_ymax = clumps[s][1]
	core.register_node("cow_core:grass_clump_"..s, {
		description = S("Grass Clump (size @1)", s),
		walkable = false,
		paramtype = "light",
		sunlight_propagates = true,
		drawtype = "plantlike",
		paramtype2 = "meshoptions",
		tiles = {
			"cow_core_grass_clump_"..s..".png"
		},
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, selection_ymax, 0.5 },
		},
		waving = 1,
	})
end
core.register_node("cow_core:wheat", {
	description = S("Wheat"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	tiles = {
		"cow_core_wheat.png"
	},
	waving = 1,
})
core.register_node("cow_core:maize", {
	description = S("Maize"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	tiles = {
		"cow_core_maize.png"
	},
})
core.register_node("cow_core:maize_ripe", {
	description = S("Ripe Maize"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	tiles = {
		"cow_core_maize_ripe.png"
	},
})


core.register_node("cow_core:maize_top", {
	description = S("Maize Top"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	tiles = {
		"cow_core_maize_top.png"
	},
})

core.register_node("cow_core:bush", {
	description = S("Bush"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "plantlike",
	paramtype2 = "meshoptions",
	tiles = {
		"cow_core_bush.png"
	},
	waving = 1,
	visual_scale = 1.25,
})
core.register_node("cow_core:leaf_litter", {
	description = S("Leaf Litter"),
	walkable = false,
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, -15/32, 0.5 },
	},
	tiles = {
		"cow_core_leaf_litter.png",
		"cow_core_leaf_litter.png",
		"blank.png",
	},
	use_texture_alpha = "clip",
})


-- Technical nodes

-- Bounce blockers: This is a (small) HACK to prevent bounciness when
-- hitting a node ceiling. Since the bounciness is set to 100%, if
-- the player hits a bouncy node at the ceiling, this will create an annoying
-- infinite bouncy loop, causing the player to bounce up and down
-- forever. Not really a bug, just bad game behavior.
-- Bounce blockers were invented to work around this problem.
-- These nodes are meant to be placed automatically below solid
-- bouncy nodes automatically at level generating time.
-- Bounce blockers are invislble and flat so the player should not
-- notice them at all.
-- The simplest bounce blocker is the square bounce blocker which is
-- meant to be placed below simple solid-cube nodes and other nodes
-- with a flat square bottom.
-- The other bounce blockers are for the more complex node shapes like
-- road signs and traffic lights.

-- This is not a great solution because bounce blockers can only replace
-- "empty" nodes above a bouncy node. With special nodebox combinations,
-- like a sign node above a sign node, there still remain a few obscure
-- bouncy bottom surface the player can hit in the level.

-- TODO: If Luanti allows to disable node bounciness on the bottom sides
-- directly, remove those nodes and use the Luanti feature instead.

local bb_tiles, bb_img, bb_drawtype, bb_pointable
if core.is_creative_enabled("") then
	-- In Creative Mode, bounce blockers are visible
	bb_tiles = { "cow_core_bounce_blocker.png" }
	bb_drawtype = "nodebox"
else
	bb_img = "cow_core_bounce_blocker.png"
	bb_drawtype = "airlike"
	bb_pointable = false
end

-- The thickness of a bounce blocker. Should be relatively thin
-- but probably not TOO thin that it would confuse the collision system
local BOUNCE_BLOCKER_THICKNESS = 1/16


local bounce_blockers = {
	--~ A special invisible block that prevents bouncing (square shaped)
	{ "square", S("Square Bounce Blocker"), { -0.5, 0.5-BOUNCE_BLOCKER_THICKNESS, -0.5, 0.5, 0.5, 0.5 } },
	--~ A special invisible block that prevents bouncing (compatible with traffic lights)
	{ "traffic_lights", S("Traffic Lights Bounce Blocker"), { -3/16, 0.5-BOUNCE_BLOCKER_THICKNESS, -3/16, 3/16, 0.5, 2/16 }, "4dir" },
	--~ A special invisible block that prevents bouncing (compatible with traffic lights that "hang" from another block)
	{ "traffic_lights_below", S("Hanging Traffic Lights Bounce Blocker"),
		{
			{ -3/16, 0.5-BOUNCE_BLOCKER_THICKNESS, -3/16, 3/16, 0.5, 2/16 },
			{ -0.5, 1.5-BOUNCE_BLOCKER_THICKNESS, -0.5, 0.5, 1.5, 0.5 },
		},
	"4dir" },
	--~ A special invisible block that prevents bouncing (compatible with road sign)
	{ "sign_road", S("Road Sign Bounce Blocker"), { -0.5, 0.5-BOUNCE_BLOCKER_THICKNESS, -1/16, 0.5, 0.5, 1/16 }, "4dir" },
	{ "sign_road_below", S("Hanging Road Sign Bounce Blocker"),
		{
			{ -0.5, 0.5-BOUNCE_BLOCKER_THICKNESS, -1/16, 0.5, 0.5, 1/16 },
			{ -0.5, 1.5-BOUNCE_BLOCKER_THICKNESS, -0.5, 0.5, 1.5, 0.5 },
		},
	"4dir" },
	--~ A special invisible block that prevents bouncing (compatible with cable)
	{ "cable", S("Cable Bounce Blocker"),
		-- This nodebox goes slightly out of bounds (but
		-- still in the permissable range) so it touches the cable
		{ -1/16, 15/16 - BOUNCE_BLOCKER_THICKNESS, -0.5, 1/16, 15/16, 0.5 }, "facedir" },
}
for b=1, #bounce_blockers do
	local id = bounce_blockers[b][1]
	local desc = bounce_blockers[b][2]
	local boxes = bounce_blockers[b][3]
	local paramtype2 = bounce_blockers[b][4]
	core.register_node("cow_core:bounce_blocker_"..id, {
		description = desc,
		drawtype = bb_drawtype,
		paramtype2 = paramtype2,
		tiles = bb_tiles,
		inventory_image = bb_img,
		wield_image = bb_img,
		paramtype = "light",
		sunlight_propagates = true,
		node_box = {
			type = "fixed",
			fixed = boxes,
		},
		pointable = bb_pointable,
	})
end

-- These nodes are for replacing the top sign post segment below
-- a road sign or traffic lights node. Unlike the other bounce
-- blockers, they are visible and look identical to regular
-- sign posts, but they have an extra collision box at the top
-- to prevent hitting the bouncy part of a traffic lights
-- or road sign node from below.

core.register_node("cow_core:bounce_blocker_visible_sign_steel_post_below_sign_road", {
	description = S("Bounce-Blocking Steel Sign Post for Road Sign"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	node_box = {
		type = "fixed",
		fixed = {
			{ -1/16, -0.5, -1/16, 1/16, 0.5, 1/16 },
		},
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{ -1/16, -0.5, -1/16, 1/16, 0.5, 1/16 },
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{ -1/16, -0.5, -1/16, 1/16, 0.5-BOUNCE_BLOCKER_THICKNESS, 1/16 },
			-- This box blocks bouncing with the bottom side of a road sign above
			{ -0.5, 0.5-BOUNCE_BLOCKER_THICKNESS, -1/16, 0.5, 0.5, 1/16 },
		},
	},
	tiles = { { name = "cow_core_sign_steel_post.png", align_style = "world" } },
})
core.register_node("cow_core:bounce_blocker_visible_sign_steel_post_below_traffic_lights", {
	description = S("Bounce-Blocking Steel Sign Post for Traffic Lights"),
	paramtype = "light",
	sunlight_propagates = true,
	drawtype = "nodebox",
	paramtype2 = "4dir",
	node_box = {
		type = "fixed",
		fixed = {
			{ -1/16, -0.5, -1/16, 1/16, 0.5, 1/16 },
		},
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{ -1/16, -0.5, -1/16, 1/16, 0.5, 1/16 },
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{ -1/16, -0.5, -1/16, 1/16, 0.5-BOUNCE_BLOCKER_THICKNESS, 1/16 },
			-- This box blocks bouncing with the bottom side of traffic lights above
			{ -3/16, 0.5-BOUNCE_BLOCKER_THICKNESS, -3/16, 3/16, 0.5, 2/16 },
		},
	},
	tiles = { { name = "cow_core_sign_steel_post.png", align_style = "world" } },
})


