cow_results = {}

-- Returns formspec string for allow_close.
local allow_close = function(player)
	if core.is_creative_enabled(player:get_player_name()) then
		-- We allow closing formspec in creative formspec for convenience
		return "allow_close[true]"
	else
		return "allow_close[false]"
	end
end

function cow_results.show_results(player, data)
	local small = cow_gui.is_small_hud_enabled(player)
	local score_img, score_size = cow_gui.render_integer(data.score, nil, nil, small)
	local score_w = score_size.x / score_size.y

	local score_h = 0.7
	score_w = score_w * score_h

	local highscore = data.highscore

	local highscore_img, highscore_size = cow_gui.render_integer(highscore, nil, nil, small)
	local highscore_w = highscore_size.x / highscore_size.y

	local highscore_h = score_h
	highscore_w = highscore_w * highscore_h

	local highscore_text_coords = "0.55,5.0;"..(4.547*highscore_h)..","..highscore_h
	local highscore_text_image
	if data.new_highscore == true then
		highscore_text_image = "animated_image["..highscore_text_coords..";highscore_text;"..cow_locale.get_localized_image(player, "cow_highscore_highscore_flashing.png")..";2;500;1;]"
	else
		highscore_text_image = "image["..highscore_text_coords..";"..cow_locale.get_localized_image(player, "cow_highscore_highscore.png").."]"
	end

	local form = "formspec_version[9]" ..
		"size[8.1,8.5]"..
		allow_close(player)..
		"set_focus[back;false]"..
		"style[back;fgimg_hovered="..cow_locale.get_localized_image(player, "cow_menu_back_hover.png")..";fgimg_pressed="..cow_locale.get_localized_image(player, "cow_menu_back_pressed.png").."]"..
		"image[0.35,3;7.45,"..(score_h*5.35)..";cow_gui_text_border.png;8]"..

		-- Score
		"image[0.55,3.2;"..(3.375*score_h)..","..score_h..";"..cow_locale.get_localized_image(player, "cow_results_score.png").."]"..
		"image[0.7,"..(3.4+score_h)..";"..score_w..","..score_h..";"..core.formspec_escape(score_img).."]"..

		-- Highscore
		highscore_text_image..
		"image[0.7,"..(5.2+highscore_h)..";"..highscore_w..","..highscore_h..";"..core.formspec_escape(highscore_img).."]"..

		"image[1,0.5;6,1.50512;"..cow_locale.get_localized_image(player, "cow_results_results.png").."]"..
		"image_button[0.5,7.3;2.49160,0.75389;"..cow_locale.get_localized_image(player, "cow_menu_back.png")..";back;]"

	core.show_formspec(player:get_player_name(), "cow_results:results", form)
end

core.register_on_player_receive_fields(function(player, formname, fields)
	if formname == "cow_results:results" then
		if fields.back then
			local detached = cow_holder.hold_player(player)
			if detached then
				core.after(0, function()
					if player and player:is_player() then
						cow_menu.open_menu(player, true)
					end
				end)
			else
				cow_menu.open_menu(player, true)
			end
		end
	end
end)


