local S = core.get_translator("cow_menu")
local F = core.formspec_escape
local H = core.hypertext_escape

local PLAY_TIME = 120

cow_menu = {}

-- Returns formspec string for allow_close.
local allow_close = function(player)
	if core.is_creative_enabled(player:get_player_name()) then
		-- We allow closing formspec in creative formspec for convenience
		return "allow_close[true]"
	else
		return "allow_close[false]"
	end
end

cow_menu.open_menu = function(player, update_state)
	if update_state ~= false then
		local detached = cow_holder.unhold_player(player)
		if not detached then
			local parent = player:get_attach()
			if parent then
				local lua = parent:get_luaentity()
				core.log("info", "[cow_menu] Detaching player from "..(lua and lua.name).." ("..tostring(parent:get_guid())..")")
				player:set_detach()
				detached = true
			end
		end
		cow_game.set_state(cow_game.STATE_MENU)
		cow_objects.remove_all_level_objects()
		cow_game.stop_play(player)

		player:set_camera({mode="third"})
		if cow_highscore.get_highscore() > 0 then
			cow_gui.show_highscore(player)
		end
		player:hud_set_flags({crosshair=false})

		local enter_menu_level = function()
			if not (player and player:is_player()) then
				return
			end
			local level_num = cow_levels.get_level_by_name("menu_lab")
			cow_levels.init_level(level_num)
			cow_levels.go_to_level(player, level_num)
			cow_player.set_texture_mode(player, "normal")
		end

		if detached then
			-- Enter menu level delayed if we have been detached because
			-- sometimes setting the pos after detach does
			-- not work (as of Luanti 5.14.0)
			core.after(0, function()
				enter_menu_level()
			end)
		else
			enter_menu_level()
		end
	end

	local music_button
	if cow_music.is_enabled() then
		music_button = "style[music;fgimg_hovered=cow_menu_music_hover.png;fgimg_pressed=cow_menu_music_pressed.png]"..
			"image_button[7,6.5;0.8,0.8;cow_menu_music.png;music;]"..
			"tooltip[music;"..F(S("Turn music off")).."]"
	else
		music_button = "style[music;fgimg_hovered=cow_menu_music_off_hover.png;fgimg_pressed=cow_menu_music_off_pressed.png]"..
			"image_button[7,6.5;0.8,0.8;cow_menu_music_off.png;music;]"..
			"tooltip[music;"..F(S("Turn music on")).."]"
	end
	local form = "formspec_version[9]" ..
		"size[8,7.5]"..
		allow_close(player)..
		"set_focus[start;false]"..
		"style[start;fgimg_hovered="..cow_locale.get_localized_image(player, "cow_menu_play_hover.png")..";fgimg_pressed="..cow_locale.get_localized_image(player, "cow_menu_play_pressed.png").."]"..
		"style[help;fgimg_hovered="..cow_locale.get_localized_image(player, "cow_menu_help_hover.png")..";fgimg_pressed="..cow_locale.get_localized_image(player, "cow_menu_help_pressed.png").."]"..
		"style[exit;fgimg_hovered="..cow_locale.get_localized_image(player, "cow_menu_exit_hover.png")..";fgimg_pressed="..cow_locale.get_localized_image(player, "cow_menu_exit_pressed.png").."]"..
		"style_type[image;noclip=true]"..
		"image[1.28572,-2.25;5.42856,2;"..cow_locale.get_localized_image(player, "cow_menu_header.png").."]"..
		"image_button[0.884755,1;6.23049,1.50778;"..cow_locale.get_localized_image(player, "cow_menu_play.png")..";start;]"..
		"image_button[0.884755,3;6.23049,1.50778;"..cow_locale.get_localized_image(player, "cow_menu_help.png")..";help;]"..
		"image_button[0.884755,5;6.23049,1.50778;"..cow_locale.get_localized_image(player, "cow_menu_exit.png")..";exit;]"..
		music_button

	core.show_formspec(player:get_player_name(), "cow_menu:menu", form)
end

-- We do not insert hypertext tags into the translatable strings directly,
-- but instead hide them behind the @1, @2, etc. placeholders.
-- These variables are used as temporary COW_TAG symbols, starting with the ASCII ESC
-- characters to not interfere with core.hypertext_escape.
-- Once the hypertext escapes have been performed, those temporary COW_TAG
-- symbols will be replaced with the REAL hypertext tags.
local ESC_HL = "\x1BCOW_TAG_HL_START"
local ESC_HL_END = "\x1BCOW_TAG_HL_END"
local ESC_I = "\x1BCOW_TAG_I_START"
local ESC_I_END = "\x1BCOW_TAG_I_END"
local ESC_B = "\x1BCOW_TAG_B_START"
local ESC_B_END = "\x1BCOW_TAG_B_END"

local help_hypertext =
"<tag name=_cow_hl color=#e3c054>"..
"<style color=#ebecdc>"..
"<bigger>"..H(S("Help")).."</bigger>".."\n"..
--~ Text will be formated between the following placeholders: @1 and @2, @3 and @4
H(S("@1C.O.W.@2 is a top secret military experiment with the goal to turn ordinary farm animals into weapons: the @3Cows of War@4.", ESC_HL, ESC_HL_END, ESC_HL, ESC_HL_END)).."\n"..
--~ Text will be formated between the following placeholders: @1 and @2, @3 and @4
H(S("But one brave cow managed to breach containment. That cow is @1you@2. You want @3revenge@4!", ESC_I, ESC_I_END, ESC_B, ESC_B_END)).."\n\n"..

"<big>"..H(S("Goal")).."</big>\n"..
--~ Text will be formated between the following placeholders: @1 and @2, @3 and @4, @5 and @6
H(S("You have @1three lives@2 and @3two minutes@4 to destroy your enemies using your deadly @5laser eye@6.", ESC_HL, ESC_HL_END, ESC_HL, ESC_HL_END, ESC_HL, ESC_HL_END)).."\n"..
H(S("Collect as many points as possible and improve your highscore!")).."\n\n"..

"<big>"..H(S("Gameplay")).."</big>".."\n"..

H(S("Due to military experiments, your body behaves in funny ways:")).."\n"..
--~ Text between @1 and @2 will be formatted
H(S("• Your @1laser eye shoots automatically@2; it cannot be turned off", ESC_HL, ESC_HL_END)).."\n"..
--~ Text between @1 and @2 will be formatted
H(S("• Your @1super bouncy body@2 will bounce off surfaces", ESC_HL, ESC_HL_END)).."\n"..
--~ Text between @1 and @2 will be formatted
H(S("• You can @1boost@2 to the left, right, front or back", ESC_HL, ESC_HL_END)).."\n\n"..

H(S("If you get hit, you lose a life.")).."\n"..
H(S("The game ends when the timer runs out or you’ve lost all lives.")).."\n\n"..

"<big>"..H(S("Controls")).."</big>".."\n"..
--~ Text between @1 and @2 will be formatted
H(S("• @1Look@2 at enemies to hit them with laser beams.", ESC_HL, ESC_HL_END)).."\n"..
--~ Text between @1 and @2 will be formatted
H(S("• Use the @1movement keys@2 to move.", ESC_HL, ESC_HL_END)).."\n"..
--~ Text between @1 and @2 will be formatted
H(S("• Hold down @1Aux1@2 and press a movement key to boost in that direction.", ESC_HL, ESC_HL_END)).."\n"..
--~ Text between @1 and @2 will be formatted
H(S("• If your bounce height is low, hold down the @1Jump@2 key before hitting the ground to gain height", ESC_HL, ESC_HL_END)).."\n\n"..

H(S("Your boost ability needs recharging. The double arrows at the bottom turn green when you can boost."))..
"</style>"

-- Our hypertext string is complete, now we replace the COW_TAG symbols
-- with the REAL hypertext tags that must NOT be escaped by core.hypertext_escape.
help_hypertext = string.gsub(help_hypertext, ESC_HL, "<_cow_hl><b>")
help_hypertext = string.gsub(help_hypertext, ESC_HL_END, "</b></_cow_hl>")
help_hypertext = string.gsub(help_hypertext, ESC_I, "<i>")
help_hypertext = string.gsub(help_hypertext, ESC_I_END, "</i>")
help_hypertext = string.gsub(help_hypertext, ESC_B, "<b>")
help_hypertext = string.gsub(help_hypertext, ESC_B_END, "</b>")

core.register_on_player_receive_fields(function(player, formname, fields)
	if formname == "cow_menu:menu" then
		if fields.start then
			core.close_formspec(player:get_player_name(), formname)
			local level_num = cow_levels.get_level_by_name("town")
			local start_play = function()
				cow_game.start_play(player, { time = PLAY_TIME, level = level_num })
			end
			if not cow_levels.are_levels_built() then
				cow_game.set_state(cow_game.STATE_LOADING_LEVEL)
				core.log("action", "[cow_menu] Player wanted to start game but has to wait for levels to be built first")
				core.show_formspec(player:get_player_name(), "cow_menu:loading_level",
					"formspec_version[9]"..
					"size[8,3]"..
					allow_close(player)..
					"image[0.5,0.5;7,1;cow_gui_text_border.png;8]"..
					"style_type[label;textcolor=#ebecdc]"..
					"label[1,1;"..F(S("Loading …")).."]"..
					"button_exit[2.75,1.9;2.3,0.75;cancel;"..F(S("Cancel")).."]"
					)
				cow_levels.register_on_levels_built(function()
					if cow_game.get_state() == cow_game.STATE_LOADING_LEVEL then
						core.close_formspec(player:get_player_name(), "cow_menu:loading_level")
						start_play()
					end
				end)
			else
				start_play()
			end
		elseif fields.help then
			local form = "formspec_version[9]" ..
			"size[11,10.5]"..
			allow_close(player)..
			"style_type[box;colors=#1e7453ff;bordercolors=#232228ff;borderwidths=-2]"..
			"image[0.4,0.4;10.2,8.7;cow_gui_text_border.png;8]"..
			"hypertext[0.65,0.65;9.7,8.2;help_hypertext;"..F(help_hypertext).."]"..
			"style[back;fgimg_hovered="..cow_locale.get_localized_image(player, "cow_menu_back_hover.png")..";fgimg_pressed="..cow_locale.get_localized_image(player, "cow_menu_back_pressed.png").."]"..
			"image_button[0.5,9.35;2.49160,0.75389;"..cow_locale.get_localized_image(player, "cow_menu_back.png")..";back;]"
			core.show_formspec(player:get_player_name(), "cow_menu:help", form)
		elseif fields.exit then
			core.request_shutdown()
			core.show_formspec(player:get_player_name(), "cow_menu:shutdown",
				"formspec_version[9]"..
				"size[8,2]"..
				allow_close(player)..
				"image[0.5,0.5;7,1;cow_gui_text_border.png;8]"..
				"style_type[label;textcolor=#ebecdc]"..
				"label[1,1;"..F(S("Shutting down …")).."]")
		elseif fields.music then
			cow_music.toggle_music(player)
			cow_menu.open_menu(player, false)
		end
	elseif formname == "cow_menu:help" then
		if fields.back then
			cow_menu.open_menu(player, false)
		end
	elseif formname == "cow_menu:loading_level" then
		if fields.cancel then
			cow_menu.open_menu(player, true)
		end
	end
end)

core.register_on_joinplayer(function(player)
	if core.is_creative_enabled(player:get_player_name()) then
		return
	end
	if cow_check_movement_settings.check_movement_settings() then
		cow_menu.open_menu(player, true)
	else
		player:set_camera({mode="third"})
		cow_game.set_state(cow_game.STATE_MENU)
		local level_num = cow_levels.get_level_by_name("menu_lab")
		cow_levels.init_level(level_num)
		cow_levels.go_to_level(player, level_num)
		cow_player.set_texture_mode(player, "normal")
	end
end)

cow_check_movement_settings.register_on_dismiss_warning(function(player)
	cow_menu.open_menu(player, true)
end)
