local S = core.get_translator("cow_music")

cow_music = {}

local DEFAULT_GAIN = 0.2
local MUSIC_FADE_STEP = 1

local music_enabled = true

local music_gain = tonumber(core.settings:get("cow_music_gain") or DEFAULT_GAIN)
if music_gain <= 0.0 then
	music_gain = DEFAULT_GAIN
	music_enabled = false
elseif music_gain > 1.0 then
	music_gain = 1.0
end
core.log("action", "[cow_music] Initial music gain: "..music_gain)

local music_id

local function play_music(player)
	music_id = core.sound_play({name="cow_music_snabisch_techno_minutes_nes", gain=music_gain}, {to_player=player:get_player_name(), loop=true})
	core.settings:set("cow_music_gain", music_gain)
	core.log("action", "[cow_music] Music started")
	music_enabled = true
end
local function stop_music(player)
	if music_id then
		core.sound_stop(music_id)
		music_id = nil
		music_enabled = false
	end
	core.settings:set("cow_music_gain", 0.0)
	core.log("action", "[cow_music] Music stopped")
end
core.register_on_joinplayer(function(player)
	if music_enabled then
		play_music(player)
	end
end)

function cow_music.is_enabled()
	return music_enabled
end

function cow_music.toggle_music(player)
	music_enabled = not music_enabled
	if music_enabled then
		play_music(player)
	else
		stop_music(player)
	end
end

function cow_music.set_gain(player, gain)
	gain = math.min(1.0, math.max(0.0, gain))
	if gain == 0 then
		stop_music(player)
	else
		core.settings:set("cow_music_gain", gain)
		core.log("action", "[cow_music] Music gain set to "..gain)
		if music_id then
			core.sound_fade(music_id, MUSIC_FADE_STEP, gain)
			if gain == 0 then
				music_id = 0
			end
		else
			play_music(player)
		end
	end
	if gain > 0 then
		music_gain = gain
	end
end

core.register_chatcommand("music", {
	description = S("Toggle music or set music volume"),
	privs = { server = true },
	--~ Volume parameter for /music command
	params = S("[<volume>]"),
	func = function(name, param)
		local player = core.get_player_by_name(name)
		if not player then
			return false, S("No player.")
		end
		if param == "" then
			cow_music.toggle_music(player)
			if music_enabled then
				return true, S("Music enabled (volume: @1%).", math.floor(music_gain*100))
			else
				return true, S("Music disabled.")
			end
		else
			local volume = tonumber(param)
			if not volume then
				return false
			end
			if volume > 1 or volume < 0 then
				return false, S("Volume must be between 0.0 and 1.0.")
			end
			cow_music.set_gain(player, volume)
			if volume == 0 then
				return true, S("Music disabled.")
			else
				return true, S("Music volume set to @1%.", math.floor(volume*100))
			end
		end
	end,
})

