local S = core.get_translator("eb_immortal")

core.register_chatcommand("immortal", {
	description = S("Toggle immortability"),
	privs = { server = true },
	func = function(name, param)
		local player = core.get_player_by_name(name)
		if not player then
			return false, S("No player.")
		end
		local pmeta = player:get_meta()
		local immortal = pmeta:get_int("eb_immortal:immortal") == 1
		if immortal then
			pmeta:set_int("eb_immortal:immortal", 0)
			return true, S("You’re no longer immortal.")
		else
			pmeta:set_int("eb_immortal:immortal", 1)
			return true, S("You’re now immortal.")
		end
	end,
})

core.register_on_joinplayer(function(player)
	local pmeta = player:get_meta()
	local immortal = pmeta:get_int("eb_immortal:immortal") == 1
	if immortal then
		core.chat_send_player(player:get_player_name(), S("You’re immortal. Use “/immortal” to become mortal again."))
	end
end)
