local S = core.get_translator("eb_graffiti")

local register_grafitti = function(subname, def)
	local nb, tile
	if def.size == 64 then
		nb = { -0.5, -0.5, 31/64, 1.5, 1.5, 0.5 }
		tile = { name = def.image, align_style = "world", scale = 2 }
	else
		nb = { -0.5, -0.5, 31/64, 0.5, 0.5, 0.5 }
		tile = def.image
	end
	core.register_node("eb_graffiti:"..subname, {
		description = S("Graffiti (@1)", def.description),
		paramtype = "light",
		sunlight_propagates = true,
		drawtype = "nodebox",
		paramtype2 = "facedir",
		groups = { editor_breakable = 1, graffiti = 1 },
		node_box = {
			type = "fixed",
			fixed = nb,
		},
		tiles = { "blank.png", "blank.png", "blank.png", "blank.png", "blank.png", tile },
		use_texture_alpha = "blend",
		inventory_image = def.image,
		wield_image = def.image,
		walkable = false,
		pointable = true,
		on_construct = function(pos)
			local meta = core.get_meta(pos)
			meta:set_string("infotext", def.text)
		end,
	})
end

register_grafitti("thing_drawn", {
	description = S("The Thing (drawing)"),
	text = "",
	size = 64,
	image = "eb_graffiti_thing_drawn.png",
})
register_grafitti("thing", {
	description = S("The Thing (text)"),
	text = S("BEWARE THE THING!"),
	size = 64,
	image = "eb_graffiti_thing.png",
})

register_grafitti("unseen", {
	description = S("Unseen"),
	text = S("THE UNSEEN ARE LOST."),
	size = 64,
	image = "eb_graffiti_unseen.png",
})
register_grafitti("push", {
	-- "Push", as in "push a button"
	description = S("Push"),
	-- "push", as in "push a button"
	text = S("PUSH\n↓"),
	size = 32,
	image = "eb_graffiti_push.png",
})
register_grafitti("good_eyes", {
	description = S("Good Eyes"),
	text = S("GOOD EYES PROTECT."),
	size = 64,
	image = "eb_graffiti_good_eyes.png",
})
register_grafitti("evil_eyes", {
	description = S("Evil Eyes"),
	text = S("EVIL EYES: YOUR DEMISE."),
	size = 64,
	image = "eb_graffiti_evil_eyes.png",
})
register_grafitti("open", {
	description = S("Open Eyes"),
	text = S("OPEN THE EYES!"),
	size = 64,
	image = "eb_graffiti_open.png",
})
register_grafitti("ritual", {
	description = S("Ritual"),
	text = S("PERFORM THE RITUAL!"),
	size = 64,
	image = "eb_graffiti_ritual.png",
})
register_grafitti("stand", {
	description = S("Stand"),
	text = S("STAND HERE"),
	size = 32,
	image = "eb_graffiti_stand.png",
})
register_grafitti("symbol_arrow", {
	description = S("Straight Arrow Symbol"),
	text = "",
	size = 32,
	image = "eb_graffiti_symbol_arrow.png",
})
register_grafitti("symbol_arrow_diagonal", {
	description = S("Diagonal Arrow Symbol"),
	text = "",
	size = 32,
	image = "eb_graffiti_symbol_arrow_diagonal.png",
})

register_grafitti("symbol_eye", {
	description = S("Eye Symbol"),
	text = "",
	size = 32,
	image = "eb_graffiti_symbol_eye.png",
})

register_grafitti("wasd", {
	description = S("PC Movement Controls"),
	text =
		S("W: ↑").."\n"..
		S("A: ←").."\n"..
		S("S: ↓").."\n"..
		S("D: →"),
	size = 64,
	image = "eb_graffiti_wasd.png",
})
register_grafitti("chosen", {
	description = S("Chosen"),
	text = S("YOU’VE BEEN CHOSEN."),
	size = 64,
	image = "eb_graffiti_chosen.png",
})
register_grafitti("restart", {

	description = S("Restart"),
	text = S("RESTART"),
	size = 32,
	image = "eb_graffiti_restart.png",
})
register_grafitti("thank", {
	description = S("Thank"),
	text = S("THANK YOU FOR PLAYING!"),
	size = 64,
	image = "eb_graffiti_thank.png",
})
register_grafitti("black_glass", {
	description = S("Black Glass"),
	text = S("THEY CAN’T SEE THRU BLACK GLASS."),
	size = 64,
	image = "eb_graffiti_black_glass.png",
})
register_grafitti("patience", {
	description = S("Patience"),
	text = S("PATIENCE IS A VIRTUE."),
	size = 64,
	image = "eb_graffiti_patience.png",
})
register_grafitti("look_back", {
	description = S("Look Back"),
	text = S("LOOK BACK TO MOVE FORWARDS."),
	size = 64,
	image = "eb_graffiti_look_back.png",
})



for number=1, 9 do
	register_grafitti("number_"..number, {
		description = S("Number @1", tostring(number)),
		text = "",
		size = 32,
		image = "eb_graffiti_number_"..number..".png",
	})
end
