eb_hud = {}

local S = core.get_translator("eb_hud")

eb_hud.MAX_DANGER_LEVEL = 6

local hud_good = { active = false }
local hud_evil = { active = false }
local hud_danger = { active = false, danger_level = 0 }

eb_hud.update_danger_meter = function(danger_level)
	local player = core.get_player_by_name("singleplayer")
	if not player then
		return false
	end
	if danger_level and danger_level > 0 then
		if hud_danger.danger_level and hud_danger.danger_level == danger_level then
			return false
		end
		if hud_danger.active then
			player:hud_change(hud_danger.id, "text", "eb_hud_danger_meter.png^[mask:eb_hud_danger_meter_mask_"..danger_level..".png")
		else
			hud_danger.active = true
			hud_danger.id = player:hud_add({
				type = "image",
				position = { x = 0.5, y = 1 },
				offset = { x = 0, y = -160 },
				align = { x = 0, y = 0 },
				text = "eb_hud_danger_meter.png^[mask:eb_hud_danger_meter_mask_"..danger_level..".png",
				scale = { x = 5, y = 5 },
			})
		end
		hud_danger.danger_level = danger_level
		return true
	else
		if hud_danger.active then
			player:hud_remove(hud_danger.id)
			hud_danger.id = nil
			hud_danger.active = false
			hud_danger.danger_level = 0
		end
		return true
	end
end

eb_hud.update_eyeball_counters = function(good_eyeballs, evil_eyeballs)
	local player = core.get_player_by_name("singleplayer")
	if not player then
		return
	end
	local handle_counter = function(hud_table, eyeball_count, config)
		if eyeball_count and (eyeball_count ~= 0 or config.hide_if_zero ~= true) then
			local function get_text_color()
				if eyeball_count == 0 then
					return config.text_color_0
				elseif eyeball_count == 1 then
					return config.text_color_1
				else
					return config.text_color_more
				end
			end
			if hud_table.active then
				player:hud_change(hud_table.id_count, "text", S("×@1", eyeball_count))
				player:hud_change(hud_table.id_count, "number", get_text_color())
			else
				hud_table.active = true
				hud_table.id_icon = player:hud_add({
					type = "image",
					position = { x = 0.5, y = 1 },
					offset = { x = config.x_offset -32, y = -64 },
					align = { x = 0.5, y = -1 },
					text = config.texture,
					scale = { x = 2, y = 2 },
				})
				hud_table.id_count = player:hud_add({
					type = "text",
					position = { x = 0.5, y = 1 },
					offset = { x = config.x_offset +32, y = -64 },
					align = { x = 1, y = -1 },
					text = S("×@1", eyeball_count),
					number = get_text_color(),
					size = { x = 2, y = 2 },
				})
			end
		else
			if hud_table.active then
				player:hud_remove(hud_table.id_count)
				player:hud_remove(hud_table.id_icon)
				hud_table.active = false
				hud_table.id_count = nil
				hud_table.id_icon = nil
			end
		end
	end
	handle_counter(hud_good, good_eyeballs, { texture = "eb_hud_icon_eyeball_good.png", x_offset = -100, text_color_0 = 0xFF0000, text_color_1 = 0xFFFF00, text_color_more = 0xFFFFFF })
	handle_counter(hud_evil, evil_eyeballs, { texture = "eb_hud_icon_eyeball_evil.png", x_offset = 100, text_color_0 = 0xFFFFFF, text_color_1 = 0xFF0000, text_color_more = 0xFF0000, hide_if_zero = true })
end

core.register_on_joinplayer(function(player)
	player:hud_set_flags({minimap=false, minimap_radar=false})
end)
