local S = core.get_translator("eb_core")

local particlespawners = {}

local add_particlespawner = function(pos, pdef)
	local hash = core.hash_node_position(pos)
	if particlespawners[hash] then
		core.delete_particlespawner(particlespawners[hash])
	end
	local handle = core.add_particlespawner(pdef)
	particlespawners[hash] = handle
end
local remove_particlespawner = function(pos)
	local hash = core.hash_node_position(pos)
	if particlespawners[hash] then
		core.delete_particlespawner(particlespawners[hash])
		particlespawners[hash] = nil
	end
end

core.register_node("eb_core:clean", {
	description = S("Clean Stone Block"),
	tiles = { "eb_core_clean.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:clean_rhombus", {
	description = S("Rhombus Clean Stone Block"),
	tiles = { "eb_core_clean_rhombus.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:clean_carved", {
	description = S("Carved Clean Stone Block"),
	tiles = { "eb_core_clean_carved.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})

core.register_node("eb_core:clean_smooth", {
	description = S("Smooth Clean Stone Block"),
	tiles = { "eb_core_clean_smooth.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:wall", {
	description = S("Stone Wall"),
	tiles = { "eb_core_wall.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:wall_double", {
	description = S("Double Stone Wall"),
	tiles = { "eb_core_wall_double.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})

core.register_node("eb_core:plates", {
	description = S("Stone Plates"),
	paramtype2 = "facedir",
	tiles = { "eb_core_tile.png", "eb_core_tile.png", "eb_core_plates.png", "eb_core_plates.png", "eb_core_plates.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})

core.register_node("eb_core:wall_cracked", {
	description = S("Cracked Stone Wall"),
	tiles = { "eb_core_wall_cracked.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:lamp_on", {
	description = S("Lamp (on)"),
	tiles = { "eb_core_lamp_on.png" },
	groups = { editor_breakable = 1, receiver = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
	light_source = core.LIGHT_MAX,
	paramtype = "light",
	_eb_toggle = function(pos)
		local node = core.get_node(pos)
		node.name = "eb_core:lamp_off"
		core.sound_play({name="eb_core_lamp_off", gain=0.3}, {pos=pos}, true)
		core.swap_node(pos, node)
	end,
})
core.register_node("eb_core:lamp_off", {
	description = S("Lamp (off)"),
	tiles = { "eb_core_lamp_off.png" },
	groups = { editor_breakable = 1, receiver = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
	_eb_toggle = function(pos)
		local node = core.get_node(pos)
		node.name = "eb_core:lamp_on"
		core.sound_play({name="eb_core_lamp_on", gain=0.3}, {pos=pos}, true)
		core.swap_node(pos, node)
	end,
})

core.register_node("eb_core:chain", {
	description = S("Chain"),
	tiles = { "eb_core_chain.png" },
	groups = { editor_breakable = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
	drawtype = "plantlike",
	paramtype = "light",
	paramtype2 = "wallmounted",
	place_param2 = 1,
	sunlight_propagates = true,
	node_box = {
		type = "fixed",
		fixed = { -3/32, -0.5, -3/32, 3/32, 0.5, 3/32 },
	},
	selection_box = {
		type = "fixed",
		fixed = { -3/32, -0.5, -3/32, 3/32, 0.5, 3/32 },
	},

})

core.register_node("eb_core:blood_source", {
	description = S("Blood Source"),
	tiles = { "eb_core_blood_source.png" },
	use_texture_alpha = "blend",
	drawtype = "liquid",
	groups = { liquid = 1, editor_breakable = 1 },
	pointable = false,
	walkable = false,
	liquid_alternative_source = "eb_core:blood_source",
	liquid_alternative_flowing = "eb_core:blood_flowing",
	post_effect_color = { r = 230, g = 0, b = 0, a = 220 },
	pointabilities = {
		nodes = {
			["group:liquid"] = true,
		},
	},
	paramtype = "light",
})
core.register_node("eb_core:blood_flowing", {
	description = S("Flowing Blood"),
	tiles = {
		{name="eb_core_blood_flowing.png", animation={type="vertical_frames", aspect_w=32, aspect_h=32, length=1}},
	},
	special_tiles = {
		{name="eb_core_blood_flowing_anim.png", animation={type="vertical_frames", aspect_w=32, aspect_h=32, length=1}},
		{name="eb_core_blood_flowing_anim.png", animation={type="vertical_frames", aspect_w=32, aspect_h=32, length=1}},
	},
	use_texture_alpha = "blend",
	drawtype = "flowingliquid",
	groups = { liquid = 1, editor_breakable = 1 },
	pointable = false,
	walkable = false,
	liquid_alternative_source = "eb_core:blood_source",
	liquid_alternative_flowing = "eb_core:blood_flowing",
	post_effect_color = { r = 230, g = 0, b = 0, a = 220 },
	pointabilities = {
		nodes = {
			["group:liquid"] = true,
		},
	},
	paramtype = "light",
})

core.register_node("eb_core:tile", {
	description = S("Stone Tile"),
	tiles = { "eb_core_tile.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:tile_smooth", {
	description = S("Smooth Stone Tile"),
	tiles = { "eb_core_tile_smooth.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:tile_thick", {
	description = S("Thick Stone Tile"),
	tiles = { "eb_core_tile_thick.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:tile_carved", {
	description = S("Carved Stone Tile"),
	tiles = { "eb_core_tile_carved.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})

core.register_node("eb_core:column_small", {
	description = S("Small Stone Column"),
	paramtype2 = "facedir",
	drawtype = "nodebox",
	paramtype = "light",
	place_param2 = 0,
	node_box = {
		type = "fixed",
		fixed = { -0.25, -0.5, -0.25, 0.25, 0.5, 0.25 },
	},
	tiles = { "eb_core_column_small_top.png", "eb_core_column_small_top.png", "eb_core_column_small.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:column", {
	description = S("Stone Column"),
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = { "eb_core_column_top.png", "eb_core_column_top.png", "eb_core_column.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
-- Special block for levels. Column will be extended downwards
core.register_node("eb_core:column_extend", {
	description = S("Extension Stone Column"),
	tiles = { "eb_core_column_extend_top.png", "eb_core_column_extend_top.png", "eb_core_column.png" },
	groups = { editor_breakable = 1, stone = 1, column_extend = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
-- Special block for levels. Wall will be extended downwards
core.register_node("eb_core:wall_extend", {
	description = S("Extension Stone Wall"),
	tiles = { "eb_core_wall_extend_top.png", "eb_core_wall_extend_top.png", "eb_core_wall.png" },
	groups = { editor_breakable = 1, stone = 1, wall_extend = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})

core.register_node("eb_core:tiles", {
	description = S("Stone Fourtile"),
	tiles = { "eb_core_tiles.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:minitiles", {
	description = S("Stone Sixteentile"),
	tiles = { "eb_core_minitiles.png" },
	groups = { editor_breakable = 1, stone = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})

core.register_node("eb_core:exit", {
	description = S("Exit Block"),
	tiles = { "eb_core_exit.png", "eb_core_exit_othersides.png" },
	groups = { editor_breakable = 1, stone = 1, exit = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
	on_construct = function(pos)
		add_particlespawner(pos, {
			time = 0,
			amount = 8,
			pos = {
				min = vector.offset(pos, -0.5, 0.4, -0.5),
				max = vector.offset(pos, 0.5, 0.4, 0.5),
			},
			texture = {
				name = "eb_core_particle_eye.png",
				alpha_tween = { 1, 0, start = 0.5 },
			},
			exptime = 2,
			size = 2,
			vel = {
				min = vector.new(0, 1, 0),
				max = vector.new(0, 1.4, 0),
			},
		})
	end,
	on_destruct = function(pos)
		remove_particlespawner(pos)
	end,
})

core.register_node("eb_core:start", {
	description = S("Start Block"),
	tiles = { "eb_core_start.png" },
	groups = { editor_breakable = 1, stone = 1, start = 1 },
	sounds = eb_sounds.node_sound_stone_defaults(),
})


local register_slab = function(nodename, def)
	local tiles
	if def.tile_slab_top then
		tiles = {
			{ name = def.tile_slab_top },
			{ name = def.tile_slab_top },
			{ name = def.tile },
		}
	else
		tiles = { { name = def.tile, align_style = "world" } }
	end
	local sounds
	local groups = { editor_breakable = 1 }
	if def.material == "stone" then
		sounds = eb_sounds.node_sound_stone_defaults()
		groups.stone = 1
	end
	core.register_node(nodename.."_slab", {
		description = def.description_slab,
		groups = groups,
		tiles = tiles,
		paramtype = "light",
		paramtype2 = "facedir",
		drawtype = "nodebox",
		place_param2 = 0,
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
			},
		},
		sounds = sounds,
	})
end
local register_stair = function(nodename, def)
	local sounds
	local groups = { editor_breakable = 1 }
	if def.material == "stone" then
		sounds = eb_sounds.node_sound_stone_defaults()
		groups.stone = 1
	end
	core.register_node(nodename.."_stair", {
		description = def.description_stair,
		tiles = { { name = def.tile, align_style = "world" } },
		groups = groups,
		paramtype = "light",
		paramtype2 = "facedir",
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, -0.5, -0.5, 0.5, 0, 0.5 },
				{ -0.5, 0, 0, 0.5, 0.5, 0.5 },
			},
		},
		sounds = sounds,
	})
end
register_slab_and_stair = function(nodename, def)
	register_slab(nodename, def)
	register_stair(nodename, def)
end

register_slab_and_stair("eb_core:wall", { description_slab = S("Stone Wall Slab"), description_stair = S("Stone Wall Stair"), tile = "eb_core_wall.png", material = "stone" })
register_slab_and_stair("eb_core:wall_double", { description_slab = S("Double Stone Wall Slab"), description_stair = S("Double Stone Wall Stair"), tile = "eb_core_wall_double.png", material = "stone" })
register_slab_and_stair("eb_core:wall_cracked", { description_slab = S("Cracked Stone Wall Slab"), description_stair = S("Cracked Stone Wall Stair"), tile = "eb_core_wall_cracked.png", material = "stone" })
register_slab_and_stair("eb_core:tiles", { description_slab = S("Stone Fourtile Slab"), description_stair = S("Stone Fourtile Stair"), tile = "eb_core_tiles.png", material = "stone" })
register_slab_and_stair("eb_core:minitiles", { description_slab = S("Stone Sixteentile Slab"), description_stair = S("Stone Sixteentile Stair"), tile = "eb_core_minitiles.png", material = "stone" })
register_slab_and_stair("eb_core:clean", { description_slab = S("Clean Stone Slab"), description_stair = S("Clean Stone Stair"), tile = "eb_core_clean.png", material = "stone" })
register_slab_and_stair("eb_core:clean_rhombus", { description_slab = S("Rhombus Clean Stone Slab"), description_stair = S("Rhombus Clean Stone Stair"), tile = "eb_core_clean.png", tile_slab_top = "eb_core_clean_rhombus.png", material = "stone" })
register_slab("eb_core:clean_carved", { description_slab = S("Carved Clean Stone Slab"), tile = "eb_core_clean.png", tile_slab_top = "eb_core_clean_carved.png", material = "stone" })
register_slab_and_stair("eb_core:clean_smooth", { description_slab = S("Smooth Clean Stone Slab"), description_stair = S("Smooth Clean Stone Stair"), tile = "eb_core_clean_smooth.png", material = "stone" })

register_slab("eb_core:tile", { description_slab = S("Stone Tile Slab"), tile = "eb_core_tile_slab.png", tile_slab_top = "eb_core_tile.png", material = "stone" })
register_slab("eb_core:tile_smooth", { description_slab = S("Smooth Stone Tile Slab"), tile = "eb_core_tile_smooth_slab.png", tile_slab_top = "eb_core_tile_smooth.png", material = "stone" })
register_slab("eb_core:tile_thick", { description_slab = S("Thick Stone Tile Slab"), tile = "eb_core_tile_thick_slab.png", tile_slab_top = "eb_core_tile_thick.png", material = "stone" })
register_slab("eb_core:tile_carved", { description_slab = S("Carved Stone Tile Slab"), tile = "eb_core_tile_slab.png", tile_slab_top = "eb_core_tile_carved.png", material = "stone" })


core.register_node("eb_core:wall_panel", {
	description = S("Stone Wall Panel"),
	tiles = {
		"eb_core_wall_panel_top.png",
		"eb_core_wall_panel_top.png",
		"eb_core_wall_panel_side.png",
		"eb_core_wall_panel_side.png",
		{ name = "eb_core_wall.png", align_style = "world" },
		{ name = "eb_core_wall.png", align_style = "world" },
	},
	groups = { editor_breakable = 1, stone = 1 },
	paramtype = "light",
	paramtype2 = "facedir",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			{ 0, -0.5, -0.5, 0.5, 0, 0.5 },
		},
	},
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:mini", {
	description = S("Mini Stone"),
	tiles = { { name = "eb_core_tiles.png", align_style = "world" } },
	groups = { editor_breakable = 1, stone = 1 },
	paramtype = "light",
	paramtype2 = "facedir",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0, 0, 0 },
	},
	sounds = eb_sounds.node_sound_stone_defaults(),
})



core.register_node("eb_core:candle", {
	description = S("Candle"),
	tiles = {
		"eb_core_candle_body.png",
		"eb_core_candle_wick.png",
		"blank.png",
	},
	use_texture_alpha = "clip",
	groups = { editor_breakable = 1 },
	paramtype = "light",
	paramtype2 = "facedir",
	drawtype = "mesh",
	mesh = "eb_core_candle.gltf",
	light_source = 0,
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {
			{ -1/32, -0.5, -1/32, 1/32, -8/32, 1/32 },
		},
	},
})

core.register_node("eb_core:candle_lit", {
	description = S("Candle (lit)"),
	tiles = {
		"eb_core_candle_body.png",
		"eb_core_candle_wick.png",
		{name="eb_core_candle_flame.png", animation={type="vertical_frames",aspect_w=16,aspect_h=16,length=1}},
	},
	use_texture_alpha = "clip",
	groups = { editor_breakable = 1 },
	paramtype = "light",
	paramtype2 = "facedir",
	drawtype = "mesh",
	mesh = "eb_core_candle.gltf",
	light_source = 6,
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {
			{ -1/32, -0.5, -1/32, 1/32, -8/32, 1/32 },
		},
	},
})


core.register_node("eb_core:glass_white", {
	description = S("White Glass"),
	tiles = {
		"eb_core_glass_white.png",
	},
	use_texture_alpha = "blend",
	groups = { editor_breakable = 1, eye_sees_through = 1 },
	drawtype = "glasslike",
	paramtype = "light",
	sunlight_propagates = true,
	sounds = eb_sounds.node_sound_stone_defaults(),
})
core.register_node("eb_core:glass_black", {
	description = S("Black Glass"),
	tiles = {
		"eb_core_glass_black.png",
	},
	use_texture_alpha = "blend",
	groups = { editor_breakable = 1 },
	drawtype = "glasslike",
	paramtype = "light",
	sunlight_propagates = true,
	sounds = eb_sounds.node_sound_stone_defaults(),
})


