local S = core.get_translator("eb_floating_blocks")

eb_floating_blocks = {}

local floating_blocks_entities = {}

local register_floating_block = function(subname, source_node)
	local ndef = core.registered_nodes[source_node]
	local tiles = table.copy(ndef.tiles)
	local last_tile
	for t=1, 6 do
		if not tiles[t] then
			if not last_tile then
				last_tile = tiles[t-1]
			end
			tiles[t] = last_tile
		end
	end
	core.register_entity("eb_floating_blocks:"..subname, {
		initial_properties = {
			visual = "cube",
			static_save = false,
			physical = true,
			collide_with_objects = true,
			collisionbox = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
			selectionbox = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5, rotate = true },
			textures = tiles,
		},
		on_activate = function(self)
			self.object:set_armor_groups({immortal=1})
		end,
	})
	floating_blocks_entities["eb_floating_blocks:"..subname] = true

	-- Spawner
	core.register_node("eb_floating_blocks:spawner_"..subname, {
		description = S("Floating @1 (spawner)", ndef.description),
		drawtype = "allfaces",
		paramtype = "light",
		sunlight_propagates = true,
		visual_scale = 0.5,
		tiles = ndef.tiles,
		groups = { floating_block_spawner = 1, ["floating_block_spawner_"..subname] = 1, editor_breakable = 1 },
		_eb_spawned_floating_block = "eb_floating_blocks:"..subname,
	})
end

function eb_floating_blocks.object_is_floating_block(obj)
	local lua = obj:get_luaentity()
	if lua and floating_blocks_entities[lua.name] then
		return true
	end
	return false
end

register_floating_block("wall", "eb_core:wall")
register_floating_block("wall_double", "eb_core:wall_double")
register_floating_block("tile", "eb_core:tile")
register_floating_block("tile_smooth", "eb_core:tile_smooth")
register_floating_block("tile_thick", "eb_core:tile_thick")
register_floating_block("tile_carved", "eb_core:tile_carved")
register_floating_block("tiles", "eb_core:tiles")
register_floating_block("minitiles", "eb_core:minitiles")
register_floating_block("clean", "eb_core:clean")
register_floating_block("clean_rhombus", "eb_core:clean_rhombus")
register_floating_block("clean_smooth", "eb_core:clean_smooth")
register_floating_block("clean_carved", "eb_core:clean_carved")
