eb_triggers = {}

local S = core.get_translator("eb_triggers")

local toggle = function(eye_id, trigger_type)
	core.log("action", "[eb_triggers] Toggling '"..eye_id.."'")
	local receiver_type = string.sub(eye_id, 1, 5)
	local static_eyeballs, mobile_eyeballs = eb_levels.get_eyeballs_in_current_level()
	local receivers = eb_levels.get_receiver_nodes_in_current_level()
	if not static_eyeballs then
		core.log("error", "[eb_triggers] Not in a current level")
		return
	end
	if receiver_type == "node:" then
		local eye_node_id = tonumber(string.sub(eye_id, 6, -1))
		if not eye_node_id then
			core.log("error", "[eb_triggers] Missing eye_id in node or eye_id is not numeric")
			return
		end
		local triggered = 0
		for r=1, #receivers do
			local rpos = receivers[r]
			local rnode = core.get_node(rpos)
			local rid
			local rdef = core.registered_nodes[rnode.name]
			if rdef then
				if rdef.paramtype2 == "facedir" then
					rid = math.floor(rnode.param2 / 32)
				elseif rdef.paramtype2 == "wallmounted" then
					rid = math.floor(rnode.param2 / 8)
				elseif rdef.paramtype2 == "4dir" then
					rid = math.floor(rnode.param2 / 4)
				else
					rid = rnode.param2
				end
			end
			if eye_node_id == rid then
				core.log("action", "[eb_triggers] Triggering receiver '"..rid.."' at "..core.pos_to_string(rpos))
				triggered = triggered + 1
				if trigger_type == "see" then
					rdef._eb_toggle(rpos)
				else
					core.log("error", "[eb_triggers] Unknown trigger_type '"..tostring(trigger_type).."' for eye_id "..eye_id.."!")
				end
			end
		end
		if triggered == 0 then
			core.log("error", "[eb_triggers] Didn't find any node to trigger! (eye_id="..eye_id..")")
		end
	elseif receiver_type == "enti:" then
		local eye_enti_id = tonumber(string.sub(eye_id, 6, -1))
		if not eye_enti_id then
			core.log("error", "[eb_triggers] Missing eye_id in entity or eye_id is not numeric")
			return
		end
		local triggered = 0
		for m=1, #mobile_eyeballs do
			local ent = mobile_eyeballs[m]
			if ent._eye_id == eye_enti_id then
				core.log("action", "[eb_triggers] Triggering mobile eye #"..eye_enti_id)
				if trigger_type == "see" then
					ent:_toggle()
				elseif trigger_type == "path" then
					ent:_toggle_path()
				else
					core.log("error", "[eb_triggers] Unknown trigger_type '"..tostring(trigger_type).."' for eye_id "..eye_id.."!")
				end
				triggered = triggered + 1
			end
		end
		if triggered == 0 then
			core.log("error", "[eb_triggers] Didn't find any entity to trigger!")
		end
	else
		core.log("error", "[eb_triggers] Malformed eye_id in switch or button")
	end
end

local switch_on_rightclick = function(pos, node, clicker)
	local meta = core.get_meta(pos)
	local eye_id = meta:get_string("eye_id")
	local trigger_type = meta:get_int("trigger_type")
	local ttype
	if trigger_type == 0 then
		ttype = "see"
	elseif trigger_type == 1 then
		ttype = "path"
	else
		core.log("error", "[eb_triggers] Unknown trigger_type '"..trigger_type.."'")
	end
	if eye_id == "" then
		core.log("error", "[eb_triggers] Empty eye_id in switch or button")
		return
	end
	toggle(eye_id, ttype)
end

core.register_node("eb_triggers:switch_off", {
	description = S("Switch (off)"),
	paramtype2 = "facedir",
	tiles = {
		"eb_triggers_switch_top.png",
		"eb_triggers_switch_top.png",
		"eb_triggers_switch_side.png",
		"eb_triggers_switch_side.png",
		"eb_triggers_switch_back.png",
		"eb_triggers_switch_front_off.png",
	},
	on_punch = function(pos, node, clicker)
		if eb_editor.player_in_editor(clicker) then
			return
		end
		switch_on_rightclick(pos, node, clicker)
		node.name = "eb_triggers:switch_on"
		core.swap_node(pos, node)
	end,
	on_rightclick = function(pos, node, clicker)
		if eb_editor.player_in_editor(clicker) then
			return
		end
		switch_on_rightclick(pos, node, clicker)
		node.name = "eb_triggers:switch_on"
		core.swap_node(pos, node)
	end,
	groups = { editor_breakable = 1, switch = 1, trigger = 1 },
})

core.register_node("eb_triggers:switch_on", {
	description = S("Switch (on)"),
	paramtype2 = "facedir",
	tiles = {
		"eb_triggers_switch_top.png",
		"eb_triggers_switch_top.png",
		"eb_triggers_switch_side.png",
		"eb_triggers_switch_side.png",
		"eb_triggers_switch_back.png",
		"eb_triggers_switch_front_on.png",
	},
	on_punch = function(pos, node, clicker)
		if eb_editor.player_in_editor(clicker) then
			return
		end
		switch_on_rightclick(pos, node, clicker)
		node.name = "eb_triggers:switch_off"
		core.swap_node(pos, node)
	end,
	on_rightclick = function(pos, node, clicker)
		if eb_editor.player_in_editor(clicker) then
			return
		end
		switch_on_rightclick(pos, node, clicker)
		node.name = "eb_triggers:switch_off"
		core.swap_node(pos, node)
	end,
	groups = { editor_breakable = 1, switch = 2, trigger = 2 },
})

local register_button = function(subname, def)

	local usubname = subname
	if subname ~= "" then
		usubname = subname .. "_"
	end

	local tiles_off = {
		"eb_triggers_button_off.png",
		"eb_triggers_button_off.png",
	}
	local tiles_on = {
		"eb_triggers_button_on.png",
		"eb_triggers_button_on.png",
	}
	if def.symbol_off then
		tiles_off[1] = tiles_off[1] .. "^" .. def.symbol_off
	end
	if def.symbol_on then
		tiles_on[1] = tiles_on[1] .. "^" .. def.symbol_on
	end

	core.register_node("eb_triggers:button_"..usubname.."off", {
		description = S("@1 (off)", def.description),
		paramtype2 = "wallmounted",
		drawtype = "nodebox",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		node_box = {
			type = "wallmounted",
			wall_side = { -0.5, -12/32, -12/32, -11/32, 12/32, 12/32 },
			wall_top = { -12/32, 11/32, -12/32, 12/32, 0.5, 12/32 },
			wall_bottom = { -12/32, -0.5, -12/32, 12/32, -11/32, 12/32 },
		},
		tiles = tiles_off,
		on_punch = function(pos, node, clicker)
			if eb_editor.player_in_editor(clicker) then
				return
			end
			switch_on_rightclick(pos, node, clicker)
			core.sound_play({name="eb_triggers_button_press"}, {pos=pos}, true)
			node.name = "eb_triggers:button_"..usubname.."on"
			core.swap_node(pos, node)
		end,
		on_rightclick = function(pos, node, clicker)
			if eb_editor.player_in_editor(clicker) then
				return
			end
			switch_on_rightclick(pos, node, clicker)
			core.sound_play({name="eb_triggers_button_press"}, {pos=pos}, true)
			node.name = "eb_triggers:button_"..usubname.."on"
			core.swap_node(pos, node)
		end,
		groups = { editor_breakable = 1, button = 1, trigger = 1 },
		sounds = eb_sounds.node_sound_stone_defaults(),
	})

	core.register_node("eb_triggers:button_"..usubname.."on", {
		description = S("@1 (on)", def.description),
		paramtype2 = "wallmounted",
		drawtype = "nodebox",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		node_box = {
			type = "wallmounted",
			wall_side = { -0.5, -12/32, -12/32, -15/32, 12/32, 12/32 },
			wall_top = { -12/32, 15/32, -12/32, 12/32, 0.5, 12/32 },
			wall_bottom = { -12/32, -0.5, -12/32, 12/32, -15/32, 12/32 },
		},
		tiles = tiles_on,
		groups = { editor_breakable = 1, button = 2, trigger = 2 },
		sounds = eb_sounds.node_sound_stone_defaults(),
	})

end

register_button("", { description = S("Blank Button") })
register_button("eye", { description = S("Eye Button"), symbol_off = "eb_triggers_button_overlay_eye_off.png", symbol_on = "eb_triggers_button_overlay_eye_on.png" })
register_button("light", { description = S("Light Button"), symbol_off = "eb_triggers_button_overlay_light_off.png", symbol_on = "eb_triggers_button_overlay_light_on.png" })
