eb_sky = {}

local registered_skies = {}

eb_sky.register_sky = function(skyname, skydef)
	registered_skies[skyname] = skydef
end

local current_sky = nil
local DEFAULT_CLOUD_HEIGHT = 60
local DEFAULT_SKY = "blood_red"

eb_sky.init_sky = function(skyname)
	local player = core.get_player_by_name("singleplayer")
	if not player then
		return
	end
	player:override_day_night_ratio(1)
	player:set_sun({visible=false, sunrise_visible=false})
	player:set_moon({visible=false})
end

eb_sky.set_sky = function(skyname)
	if not skyname then
		skyname = DEFAULT_SKY
	end
	current_sky = skyname
	local skydef = registered_skies[skyname]
	local player = core.get_player_by_name("singleplayer")
	if not player then
		return
	end
	player:set_sky(skydef.sky)
	player:set_stars(skydef.stars)
	player:set_clouds(skydef.clouds)
	player:override_day_night_ratio(skydef.day_night_ratio or 1)
end
eb_sky.set_cloud_height = function(height)
	if not height then
		height = DEFAULT_CLOUD_HEIGHT
	end
	local player = core.get_player_by_name("singleplayer")
	if not player then
		return
	end
	player:set_clouds({
		height = height
	})
end

eb_sky.register_sky("gray", {
	sky = {
		type = "regular",
		clouds = true,
		sky_color = {
			day_sky = "#808080",
			day_horizon = "#808080",
			dawn_sky = "#808080",
			dawn_horizon = "#808080",
			night_sky = "#808080",
			night_horizon = "#808080",
			fog_tint_type = "custom",
			fog_sun_tint = "#000000",
			fog_moon_tint = "#000000",
		},
		fog = {
			fog_start = 0.75,
			fog_distance = -1,
		},
	},
	stars = {
		visible = false,
	},
	clouds = {
		density = 0.35,
		height = DEFAULT_CLOUD_HEIGHT,
		thickness = 2,
		speed = { x = 3, y = 3 },
		color = "#bbbbbbDE",
		ambient = "#000000",
	},
	day_night_ratio = 1.0,
})


eb_sky.register_sky("temple_blue", {
	sky = {
		type = "regular",
		clouds = true,
		sky_color = {
			day_sky = "#181D5D",
			day_horizon = "#30486F",
			dawn_sky = "#181D5D",
			dawn_horizon = "#30486F",
			night_sky = "#181D5D",
			night_horizon = "#30486F",
			fog_tint_type = "custom",
			fog_sun_tint = "#000000",
			fog_moon_tint = "#000000",
		},
		fog = {
			fog_start = 0.3,
			fog_distance = 100,
		},
	},
	stars = {
		visible = true,
		day_opacity = 1.0,
		count = 1234,
		scale = 0.7,
		star_color = "#FFFFFF80",
	},
	clouds = {
		density = 0.15,
		height = DEFAULT_CLOUD_HEIGHT,
		thickness = 4,
		speed = { x = 3, y = 0 },
		color = "#BDC3FF99",
		ambient = "#000000",
	},
	day_night_ratio = 1.0,
})


eb_sky.register_sky("blood_red", {
	sky = {
		type = "regular",
		clouds = true,
		sky_color = {
			day_sky = "#7E0000",
			day_horizon = "#BD0000",
			dawn_sky = "#7E0000",
			dawn_horizon = "#BD0000",
			night_sky = "#7E0000",
			night_horizon = "#BD0000",
			fog_tint_type = "custom",
			fog_sun_tint = "#000000",
			fog_moon_tint = "#000000",
		},
		fog = {
			fog_start = 0.3,
			fog_distance = 100,
		},
	},
	stars = {
		visible = false,
	},
	clouds = {
		density = 0.35,
		height = DEFAULT_CLOUD_HEIGHT,
		thickness = 2,
		speed = { x = 10, y = 3 },
		color = "#6C0000DE",
		ambient = "#0C0000",
	},
	day_night_ratio = 1.0,
})

eb_sky.register_sky("darkness", {
	sky = {
		type = "regular",
		clouds = false,
		sky_color = {
			day_sky = "#000000",
			day_horizon = "#000000",
			dawn_sky = "#000000",
			dawn_horizon = "#000000",
			night_sky = "#000000",
			night_horizon = "#000000",
			fog_tint_type = "custom",
			fog_sun_tint = "#000000",
			fog_moon_tint = "#000000",
		},
		fog = {
			fog_start = 0.3,
			fog_distance = 100,
		},
	},
	stars = {
		visible = false,
	},
	day_night_ratio = 0.0,
})

eb_sky.register_sky("gray_fog", {
	sky = {
		type = "regular",
		clouds = false,
		sky_color = {
			day_sky = "#202020",
			day_horizon = "#202020",
			dawn_sky = "#202020",
			dawn_horizon = "#202020",
			night_sky = "#202020",
			night_horizon = "#202020",
			fog_tint_type = "custom",
			fog_sun_tint = "#000000",
			fog_moon_tint = "#000000",
		},
		fog = {
			fog_start = 0.3,
			fog_distance = 50,
		},
	},
	stars = {
		visible = false,
	},
})
