local S = core.get_translator("eb_editor")

eb_editor = {}

eb_editor.player_in_editor = function(player)
	local pmeta = player:get_meta()
	return pmeta:get_int("eb_editor:in_editor") == 1
end

core.register_chatcommand("editor", {
	description = S("Toggle editor mode"),
	params = "",
	privs = { server = true },
	func = function(name, param)
		local player = core.get_player_by_name(name)
		local pmeta = player:get_meta()
		local editor_active = pmeta:get_int("eb_editor:in_editor") == 1
		editor_active = not editor_active
		if eb_teleport.is_teleporting() then
			eb_teleport.abort_teleport()
		end
		if editor_active then
			if core.global_exists("eb_levels") then
				eb_levels.leave_level()
			end
			eb_hud.update_eyeball_counters(nil, nil)
			if player then
				eb_player.set_editor_inventory(player)
				local pmeta = player:get_meta()
				pmeta:set_int("eb_editor:in_editor", 1)
			end
			eb_sky.set_sky("gray")
			return true, S("Editor activated.")
		else
			if player then
				eb_player.set_play_inventory(player)
				pmeta:set_int("eb_editor:in_editor", 0)
			end
			return true, S("Editor deactivated. Use “/level <number>” to play a level.")
		end
	end,
})

core.register_on_joinplayer(function(player)
	if eb_editor.player_in_editor(player) then
		eb_sky.set_sky("gray")
		eb_player.set_editor_inventory(player)
		core.chat_send_player(player:get_player_name(), S("You’re in the editor. Use “/editor” to disable it."))
	else
		eb_player.set_play_inventory(player)
	end
end)

core.register_on_placenode(function(pos, newnode, placer, oldnode, itemstack)
	if not (placer and placer:is_player()) then
		return nil
	end
	return eb_editor.player_in_editor(placer)
end)

local original_handle_node_drops = core.handle_node_drops
function core.handle_node_drops(pos, drops, player)
	if (not player) or (not player:is_player()) then
		return original_handle_node_drops(pos, drops, player)
	end
	if not eb_editor.player_in_editor(player) then
		return original_handle_node_drops(pos, drops, player)
	end
	local inv = player:get_inventory()
	if inv then
		for _, itemstack in ipairs(drops) do
			if not inv:contains_item("main", itemstack, true) then
				inv:add_item("main", itemstack)
			end
		end
	end
end

local original_item_drop = core.item_drop
function core.item_drop(itemstack, dropper, pos)
	if not eb_editor.player_in_editor(dropper) then
		return original_item_drop(itemstack, dropper, pos)
	else
		return ""
	end
end

core.register_craftitem("eb_editor:pickaxe", {
	description = S("Editor Pickaxe"),
	inventory_image = "eb_editor_pickaxe.png",
	wield_image = "eb_editor_pickaxe.png",
	tool_capabilities = {
		groupcaps = {
			editor_breakable = {uses=0, times={0, 0, 0}},
		},
	},
	pointabilities = {
		nodes = {
			["group:liquid"] = true,
		},
	},
	stack_max = 1,
})



-- Hidden debug mode
if core.settings:get_bool("eb_debug", false) == true then

	local active_waypoints = {}

	-- Dev/debug command: Toggles the display of numbers for nodes that
	-- can be triggered on and off. The trigger numbers uniquely
	-- identifies each trigger.
	local show_waypoints = false
	core.register_chatcommand("show_trigger_numbers", {
		-- Intentionally NOT translated (internal dev command)
		description = "Toggle display of trigger numbers",
		params = "",
		privs = { server = true },
		func = function(name, param)
			show_waypoints = not show_waypoints
			if show_waypoints then
				return true, "Trigger numbers activated."
			else
				local player = core.get_player_by_name(name)
				if player then
					for a=1, #active_waypoints do
						player:hud_remove(active_waypoints[a])
					end
				end
				return true, "Trigger numbers deactivated."
			end
		end,
	})

	local wptimer = 0
	core.register_globalstep(function(dtime)
		wptimer = wptimer + dtime
		if wptimer < 1 then
			return
		end
		if not show_waypoints then
			return
		end
		wptimer = 0
		local player = core.get_player_by_name("singleplayer")
		if not player then
			return
		end
		local ppos = player:get_pos()
		ppos = vector.floor(ppos)
		local offset = vector.new(7,7,7)
		local min = vector.subtract(ppos, offset)
		local max = vector.add(ppos, offset)
		local nodes = core.find_nodes_in_area(min, max, {"group:trigger", "group:receiver", "group:eyeball_mobile_spawner"})
		for w=1, #active_waypoints do
			player:hud_remove(active_waypoints[w])
		end
		active_waypoints = {}
		for n=1, #nodes do
			local npos = nodes[n]
			local node = core.get_node(npos)
			local ndef = core.registered_nodes[node.name]
			local tid
			if ndef then
				if ndef.paramtype2 == "facedir" then
					tid = math.floor(node.param2 / 32)
				elseif ndef.paramtype2 == "wallmounted" then
					tid = math.floor(node.param2 / 8)
				elseif ndef.paramtype2 == "4dir" then
					tid = math.floor(node.param2 / 4)
				else
					tid = node.param2
				end
			end
			if tid then
				local color = 0xFFFFFF
				if tid > 0 then
					color = 0x00FF00
				end
				local hid = player:hud_add({
					type = "waypoint",
					name = tostring(tid),
					z_index = -300,
					text = "",
					precision = 0,
					world_pos = npos,
					number = color,
				})
				if hid then
					table.insert(active_waypoints, hid)
				end
			end
		end
	end)
end
