eb_music = {}

local GAIN = 0.7

local registered_tracks = {}

local music_enabled = core.settings:get_bool("eb_music", true)
local current_track = nil
local track_handle = nil

eb_music.stop_track = function()
	current_track = nil
	if track_handle then
		core.sound_stop(track_handle)
		track_handle = nil
	end
	core.log("action", "[eb_music] Music track stopped")
end

eb_music.play_track = function(track_id)
	if not music_enabled then
		return
	end
	if current_track == track_id and current_track ~= nil then
		return
	end
	if not registered_tracks[track_id] then
		core.log("error", "[eb_music] Tried to play track that doesn't exist: "..tostring(track_id))
		return
	end
	if track_handle then
		core.sound_stop(track_handle)
		track_handle = nil
	end
	current_track = track_id
	track_handle = core.sound_play({name=registered_tracks[track_id].soundname}, {gain=GAIN, loop=true})
	core.log("action", "[eb_music] Now playing: "..tostring(track_id))
end

eb_music.register_music = function(id, def)
	registered_tracks[id] = { soundname = def.soundname }
end

eb_music.register_music("temple", {soundname="eb_music_temple_of_eyeballs"})
eb_music.register_music("hall", {soundname="eb_music_hall_of_forgotten_sight"})
eb_music.register_music("spooky", {soundname="eb_music_spooky_eyeballs"})

