# Eyeballs

A stealth/anti-stealth game made for Luanti Game Jam 2024 by Wuzzy.

## Version

1.3.2

(Note: The official game jam version was 1.0.2)

## System requirements

This is a video game for Luanti.
You need to install Luanti 5.12.0 or later to play it.

Luanti versions 5.10 and 5.11 also work, but it’s not
ideal because of small bugs. Check out “Known problems
in old Luanti versions” below.

## Plot

After years of experimentation, the Cult of Oculon has finally
managed to open the portal to the Realm of Eyes, where
floating eyeballs, both good and evil, live.

You’re the Chosen One. You must venture deep into the Realm
of Eyes to uncover its deepest secrets.

This realm is governed by one simple rule: The Unseen are lost.

Only those who are seen by the eyeballs will be able to
move on.

## Objective / Gameplay

You start in the headquarters of the cult. Stand on the
magic portal in the main hall to enter the Realm of Eyes.
The eyeballs are your friends … well, most of them.

From now on, you have to be seen by at least one eyeball at all times.
As long you are seen, you are safe. However, if not, then
the Thing will snatch you!

The objective is to find and stand on the portal in each location.

### On-screen indicators

The counter at the bottom of the screen shows how many eyeballs
are seeing you right now.

If you’re not seen by the friendly eyeballs, a danger bar
will appear that rapidly fills up. Once it’s full, you will be
taken by the Thing and you have to try the level again.

## Are you stuck?

If you’re stuck, you can restart the level with the chat command:

    /restart

### Level selection

If a level is just too difficult, you can cheat by selecting a level directly.
First, in the chat, grant yourself the `server` privilege by typing:

    /grantme server

Then you can select a level with:

    /level <number>

where `<number>` is a level number (starting with 1).

## Controls

In this game you can look around, walk, jump, punch and interact with things.
There is no inventory.

On PC, the default controls are:

* Look around: Move mouse
* Walk: W, A, S and D
* Jump: Space bar
* Punch/Interact: Left or right mouse click

In Luanti, you can customize the controls in the main menu.
The mobile version of Luanti has a different control scheme, of course.
Refer to the Luanti documentation for details.

## Known problems in old Luanti versions

If you use Luanti 5.10 and any of the following Luanti settings
is active, the glass textures will have a weird square shape in them:

* Mip-Mapping
* Bilinear filtering
* Trilinear filtering
* Anisotropic filtering

To fix this, either use a newer Luanti version, or enable the
setting `eb_glass_fallback` (which enables a different, less
detailed glass texture).

In Luanti versions before 5.12, the player may switch to the
3rd person camera, but this is pointless as there is no
player model.

## Credits

* Idea, programming, level design, graphics, sounds, music: Wuzzy
* German translation: Wuzzy
* Russian translation: divergency
* French translation: Nazalassa
* Spanish translation: Miguel P.L (Miguel\_PL)
* Chinese translation (simplified Han script): bright

## Translators wanted!

Eyeballs can be translated into your language. If you want to
contribute a translation, see `TRANSLATING.md` for details.

## Licensing

This game is free software.

It is released under:

* GNU GPLv3 or later (for code) and
* and CC BY 4.0 (for media)

See `LICENSE.txt` for details.
