# How graffiti is translated

## Summary

1. In this mod, both plain text and the graffiti images can be translated
2. Plain text is translated in the usual Luanti way in the PO/POT files
   in the `locale` directory
3. A graffiti image can be translated by providing the file
   `textures/locale/<original_graffiti_name>.<language>.png`
4. Make sure the graffiti transliteration in the PO files
   matches the translated image (if one exists)

## Long explanation

The graffiti in Eyeballs is translated in a special way because the graffiti is
stored as images.

There are two components to translate in this mod: Plain text and images.

## Plain text

This can be found in `locale` with in the gettext POT/PO
files. This uses the usual Luanti translation system, refer to Luanti
documentation to learn how it works.

The plain text translation contains a transliteration of the images.
This is marked by the comment "Graffiti transliteration" in the PO
files. If a translated image of the graffiti is avaliable, you must
make sure the transliteration matches the image.

## Images

These can be found in `textures/locale`. For each
graffiti texture in `textures` that contains at least on English character (for
example `textures/eb_graffiti_unseen.png`) that contains the text “THE UNSEEN
ARE LOST.”), there can be any number of translated versions of that texture.
It must be put into `textures/locale` and the file name must be the form
`<original_graffiti_name>.<language>.png`, where:

* `<original_graffiti_name>` is the texture name in `textures` (for the English
  texture) *without* the file name suffix
* `<language>` is the language code, e.g. `en`

For example, to provide a German version of `textures/eb_graffiti_unseen.png`,
provide the file `textures/locale/eb_graffiti.de.png`.

As soon a localized graffiti file is present, it will be available in the game.

Note that graffiti textures that do not contain English text cannot be
localized so any localized files will be ignored.
